/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.sink.dynamic.LRUCache;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

@Internal
class TableSerializerCache
implements Serializable {
    private final CatalogLoader catalogLoader;
    private final int maximumSize;
    private transient Map<String, SerializerInfo> serializers;

    TableSerializerCache(CatalogLoader catalogLoader, int maximumSize) {
        this.catalogLoader = catalogLoader;
        this.maximumSize = maximumSize;
    }

    RowDataSerializer serializer(String tableName, Schema schema, PartitionSpec spec) {
        return (RowDataSerializer)this.serializer((String)tableName, (Schema)schema, (PartitionSpec)spec, null, null).f0;
    }

    Tuple3<RowDataSerializer, Schema, PartitionSpec> serializerWithSchemaAndSpec(String tableName, Integer schemaId, Integer specId) {
        return this.serializer(tableName, null, null, schemaId, specId);
    }

    private Tuple3<RowDataSerializer, Schema, PartitionSpec> serializer(String tableName, @Nullable Schema unknownSchema, @Nullable PartitionSpec unknownSpec, @Nullable Integer schemaId, @Nullable Integer specId) {
        PartitionSpec spec;
        Preconditions.checkState((unknownSchema == null && unknownSpec == null) ^ (schemaId == null && specId == null), "Either the full schema/spec or their ids must be provided.");
        if (this.serializers == null) {
            this.serializers = new LRUCache<String, SerializerInfo>(this.maximumSize);
        }
        SerializerInfo info = this.serializers.computeIfAbsent(tableName, x$0 -> new SerializerInfo((String)x$0));
        Schema schema = unknownSchema != null ? unknownSchema : info.schemas.get(schemaId);
        PartitionSpec partitionSpec = spec = unknownSpec != null ? unknownSpec : info.specs.get(specId);
        if (schema == null || spec == null) {
            info.update();
            schema = info.schemas.get(schemaId);
            spec = info.specs.get(specId);
        }
        RowDataSerializer serializer = info.serializers.computeIfAbsent(schema, s2 -> new RowDataSerializer(FlinkSchemaUtil.convert(s2)));
        return Tuple3.of((Object)serializer, (Object)schema, (Object)spec);
    }

    CatalogLoader catalogLoader() {
        return this.catalogLoader;
    }

    int maximumSize() {
        return this.maximumSize;
    }

    @VisibleForTesting
    Map<String, SerializerInfo> getCache() {
        return this.serializers;
    }

    private class SerializerInfo {
        private final String tableName;
        private final Map<Schema, RowDataSerializer> serializers;
        private Map<Integer, Schema> schemas;
        private Map<Integer, PartitionSpec> specs;

        SerializerInfo(String tableName) {
            this.tableName = tableName;
            this.serializers = Maps.newHashMapWithExpectedSize(2);
            this.schemas = Maps.newHashMapWithExpectedSize(1);
            this.specs = Maps.newHashMapWithExpectedSize(0);
        }

        private void update() {
            Table table = TableSerializerCache.this.catalogLoader.loadCatalog().loadTable(TableIdentifier.parse(this.tableName));
            this.schemas = table.schemas();
            this.specs = table.specs();
        }
    }
}

