/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.Map;
import org.apache.flink.metrics.MetricGroup;
import org.apache.iceberg.flink.sink.IcebergStreamWriterMetrics;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class DynamicWriterMetrics {
    private final Map<String, IcebergStreamWriterMetrics> metrics;
    private final MetricGroup mainMetricsGroup;

    DynamicWriterMetrics(MetricGroup mainMetricsGroup) {
        this.mainMetricsGroup = mainMetricsGroup;
        this.metrics = Maps.newHashMap();
    }

    public void updateFlushResult(String fullTableName, WriteResult result) {
        this.writerMetrics(fullTableName).updateFlushResult(result);
    }

    public void flushDuration(String fullTableName, long flushDurationMs) {
        this.writerMetrics(fullTableName).flushDuration(flushDurationMs);
    }

    IcebergStreamWriterMetrics writerMetrics(String fullTableName) {
        return this.metrics.computeIfAbsent(fullTableName, tableName -> new IcebergStreamWriterMetrics(this.mainMetricsGroup, (String)tableName));
    }
}

