/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;

class DynamicSinkUtil {
    private DynamicSinkUtil() {
    }

    static Set<Integer> getEqualityFieldIds(Set<String> equalityFields, Schema schema) {
        if (equalityFields == null || equalityFields.isEmpty()) {
            if (!schema.identifierFieldIds().isEmpty()) {
                return schema.identifierFieldIds();
            }
            return Collections.emptySet();
        }
        HashSet equalityFieldIds = Sets.newHashSetWithExpectedSize((int)equalityFields.size());
        for (String equalityField : equalityFields) {
            Types.NestedField field = schema.findField(equalityField);
            Preconditions.checkNotNull(field, "Equality field %s does not exist in schema", (Object)equalityField);
            equalityFieldIds.add(field.fieldId());
        }
        return equalityFieldIds;
    }

    static int safeAbs(int input) {
        if (input >= 0) {
            return input;
        }
        if (input == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -input;
    }
}

