/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkSchemaUtil;

@Internal
class DynamicRecordInternal {
    private String tableName;
    private String branch;
    private Schema schema;
    private PartitionSpec spec;
    private int writerKey;
    private RowData rowData;
    private boolean upsertMode;
    private Set<Integer> equalityFieldIds;

    DynamicRecordInternal() {
    }

    DynamicRecordInternal(String tableName, String branch, Schema schema, RowData rowData, PartitionSpec spec, int writerKey, boolean upsertMode, Set<Integer> equalityFieldsIds) {
        this.tableName = tableName;
        this.branch = branch;
        this.schema = schema;
        this.spec = spec;
        this.writerKey = writerKey;
        this.rowData = rowData;
        this.upsertMode = upsertMode;
        this.equalityFieldIds = equalityFieldsIds;
    }

    public String tableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String branch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public Schema schema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public RowData rowData() {
        return this.rowData;
    }

    public void setRowData(RowData rowData) {
        this.rowData = rowData;
    }

    public PartitionSpec spec() {
        return this.spec;
    }

    public void setSpec(PartitionSpec spec) {
        this.spec = spec;
    }

    public int writerKey() {
        return this.writerKey;
    }

    public void setWriterKey(int writerKey) {
        this.writerKey = writerKey;
    }

    public boolean upsertMode() {
        return this.upsertMode;
    }

    public void setUpsertMode(boolean upsertMode) {
        this.upsertMode = upsertMode;
    }

    public Set<Integer> equalityFields() {
        return this.equalityFieldIds;
    }

    public void setEqualityFieldIds(Set<Integer> equalityFieldIds) {
        this.equalityFieldIds = equalityFieldIds;
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.branch, this.schema, this.spec, this.writerKey, this.rowData, this.upsertMode, this.equalityFieldIds);
    }

    public boolean equals(Object other) {
        boolean tableFieldsMatch;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DynamicRecordInternal that = (DynamicRecordInternal)other;
        boolean bl = tableFieldsMatch = Objects.equals(this.tableName, that.tableName) && Objects.equals(this.branch, that.branch) && this.schema.schemaId() == that.schema.schemaId() && Objects.equals(this.spec, that.spec) && this.writerKey == that.writerKey && this.upsertMode == that.upsertMode && Objects.equals(this.equalityFieldIds, that.equalityFieldIds);
        if (!tableFieldsMatch) {
            return false;
        }
        if (this.rowData.getClass().equals(that.rowData.getClass())) {
            return Objects.equals(this.rowData, that.rowData);
        }
        RowDataSerializer rowDataSerializer = new RowDataSerializer(FlinkSchemaUtil.convert(this.schema));
        return rowDataSerializer.toBinaryRow(this.rowData).equals((Object)rowDataSerializer.toBinaryRow(that.rowData));
    }
}

