/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.Map;
import org.apache.flink.metrics.MetricGroup;
import org.apache.iceberg.flink.sink.CommitSummary;
import org.apache.iceberg.flink.sink.IcebergFilesCommitterMetrics;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class DynamicCommitterMetrics {
    private final Map<String, IcebergFilesCommitterMetrics> metrics;
    private final MetricGroup mainMetricsGroup;

    DynamicCommitterMetrics(MetricGroup mainMetricsGroup) {
        this.mainMetricsGroup = mainMetricsGroup;
        this.metrics = Maps.newHashMap();
    }

    public void commitDuration(String fullTableName, long commitDurationMs) {
        this.committerMetrics(fullTableName).commitDuration(commitDurationMs);
    }

    public void updateCommitSummary(String fullTableName, CommitSummary stats) {
        this.committerMetrics(fullTableName).updateCommitSummary(stats);
    }

    private IcebergFilesCommitterMetrics committerMetrics(String fullTableName) {
        return this.metrics.computeIfAbsent(fullTableName, tableName -> new IcebergFilesCommitterMetrics(this.mainMetricsGroup, (String)tableName));
    }
}

