/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Strings;

@Internal
public class ManifestOutputFileFactory {
    @VisibleForTesting
    static final String FLINK_MANIFEST_LOCATION = "flink.manifests.location";
    private final Supplier<Table> tableSupplier;
    private final Map<String, String> props;
    private final String flinkJobId;
    private final String operatorUniqueId;
    private final int subTaskId;
    private final long attemptNumber;
    private final AtomicInteger fileCount = new AtomicInteger(0);

    ManifestOutputFileFactory(Supplier<Table> tableSupplier, Map<String, String> props, String flinkJobId, String operatorUniqueId, int subTaskId, long attemptNumber) {
        this.tableSupplier = tableSupplier;
        this.props = props;
        this.flinkJobId = flinkJobId;
        this.operatorUniqueId = operatorUniqueId;
        this.subTaskId = subTaskId;
        this.attemptNumber = attemptNumber;
    }

    private String generatePath(long checkpointId) {
        return FileFormat.AVRO.addExtension(String.format(Locale.ROOT, "%s-%s-%05d-%d-%d-%05d", this.flinkJobId, this.operatorUniqueId, this.subTaskId, this.attemptNumber, checkpointId, this.fileCount.incrementAndGet()));
    }

    public OutputFile create(long checkpointId) {
        String flinkManifestDir = this.props.get(FLINK_MANIFEST_LOCATION);
        TableOperations ops = ((HasTableOperations)((Object)this.tableSupplier.get())).operations();
        String newManifestFullPath = Strings.isNullOrEmpty(flinkManifestDir) ? ops.metadataFileLocation(this.generatePath(checkpointId)) : String.format("%s/%s", ManifestOutputFileFactory.stripTrailingSlash(flinkManifestDir), this.generatePath(checkpointId));
        return this.tableSupplier.get().io().newOutputFile(newManifestFullPath);
    }

    private static String stripTrailingSlash(String path) {
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

