/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.iceberg.flink.sink.FlinkWriteResult;
import org.apache.iceberg.flink.sink.IcebergStreamWriterMetrics;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class IcebergStreamWriter<T>
extends AbstractStreamOperator<FlinkWriteResult>
implements OneInputStreamOperator<T, FlinkWriteResult>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    static final long END_INPUT_CHECKPOINT_ID = Long.MAX_VALUE;
    private final String fullTableName;
    private final TaskWriterFactory<T> taskWriterFactory;
    private transient TaskWriter<T> writer;
    private transient int subTaskId;
    private transient int attemptId;
    private transient IcebergStreamWriterMetrics writerMetrics;

    IcebergStreamWriter(String fullTableName, TaskWriterFactory<T> taskWriterFactory) {
        this.fullTableName = fullTableName;
        this.taskWriterFactory = taskWriterFactory;
    }

    public void open() {
        this.subTaskId = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
        this.attemptId = this.getRuntimeContext().getTaskInfo().getAttemptNumber();
        this.writerMetrics = new IcebergStreamWriterMetrics((MetricGroup)this.metrics, this.fullTableName);
        this.taskWriterFactory.initialize(this.subTaskId, this.attemptId);
        this.writer = this.taskWriterFactory.create();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.flush(checkpointId);
        this.writer = this.taskWriterFactory.create();
    }

    public void processElement(StreamRecord<T> element) throws Exception {
        this.writer.write(element.getValue());
    }

    public void close() throws Exception {
        super.close();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void endInput() throws IOException {
        this.flush(Long.MAX_VALUE);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", this.fullTableName).add("subTaskId", this.subTaskId).add("attemptId", this.attemptId).toString();
    }

    private void flush(long checkpointId) throws IOException {
        if (this.writer == null) {
            return;
        }
        long startNano = System.nanoTime();
        WriteResult result = this.writer.complete();
        this.writerMetrics.updateFlushResult(result);
        this.output.collect((Object)new StreamRecord((Object)new FlinkWriteResult(checkpointId, result)));
        this.writerMetrics.flushDuration(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNano));
        this.writer = null;
    }
}

