/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.iceberg.flink.sink.IcebergCommittable;

public class IcebergCommittableSerializer
implements SimpleVersionedSerializer<IcebergCommittable> {
    private static final int VERSION = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(IcebergCommittable committable) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeUTF(committable.jobId());
        view.writeUTF(committable.operatorId());
        view.writeLong(committable.checkpointId().longValue());
        view.writeInt(committable.manifest().length);
        view.write(committable.manifest());
        return out.toByteArray();
    }

    public IcebergCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer view = new DataInputDeserializer(serialized);
            String jobId = view.readUTF();
            String operatorId = view.readUTF();
            long checkpointId = view.readLong();
            int manifestLen = view.readInt();
            byte[] manifestBuf = new byte[manifestLen];
            view.read(manifestBuf);
            return new IcebergCommittable(manifestBuf, jobId, operatorId, checkpointId);
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }
}

