/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.time.Duration;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingTableSupplier
implements SerializableSupplier<Table> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingTableSupplier.class);
    private final Table initialTable;
    private final TableLoader tableLoader;
    private final Duration tableRefreshInterval;
    private long lastLoadTimeMillis;
    private transient Table table;

    CachingTableSupplier(SerializableTable initialTable, TableLoader tableLoader, Duration tableRefreshInterval) {
        Preconditions.checkArgument(initialTable != null, "initialTable cannot be null");
        Preconditions.checkArgument(tableLoader != null, "tableLoader cannot be null");
        Preconditions.checkArgument(tableRefreshInterval != null, "tableRefreshInterval cannot be null");
        this.initialTable = initialTable;
        this.table = initialTable;
        this.tableLoader = tableLoader;
        this.tableRefreshInterval = tableRefreshInterval;
        this.lastLoadTimeMillis = System.currentTimeMillis();
    }

    @Override
    public Table get() {
        if (this.table == null) {
            this.table = this.initialTable;
        }
        return this.table;
    }

    Table initialTable() {
        return this.initialTable;
    }

    void refreshTable() {
        if (System.currentTimeMillis() > this.lastLoadTimeMillis + this.tableRefreshInterval.toMillis()) {
            try {
                if (!this.tableLoader.isOpen()) {
                    this.tableLoader.open();
                }
                this.table = this.tableLoader.loadTable();
                this.lastLoadTimeMillis = System.currentTimeMillis();
                LOG.info("Table {} reloaded, next min load time threshold is {}", (Object)this.table.name(), (Object)DateTimeUtil.formatTimestampMillis(this.lastLoadTimeMillis + this.tableRefreshInterval.toMillis()));
            }
            catch (Exception e) {
                LOG.warn("An error occurred reloading table {}, table was not reloaded", (Object)this.table.name(), (Object)e);
            }
        }
    }
}

