/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericRecord;

public class AvroGenericRecordToRowDataMapper
implements MapFunction<GenericRecord, RowData> {
    private final AvroToRowDataConverters.AvroToRowDataConverter converter;

    AvroGenericRecordToRowDataMapper(RowType rowType) {
        this.converter = AvroToRowDataConverters.createRowConverter((RowType)rowType);
    }

    public RowData map(GenericRecord genericRecord) throws Exception {
        return (RowData)this.converter.convert((Object)genericRecord);
    }

    public static AvroGenericRecordToRowDataMapper forAvroSchema(Schema avroSchema) {
        DataType dataType = AvroSchemaConverter.convertToDataType((String)avroSchema.toString());
        LogicalType logicalType = TypeConversions.fromDataToLogicalType((DataType)dataType);
        RowType rowType = RowType.of((LogicalType[])logicalType.getChildren().toArray(new LogicalType[0]));
        return new AvroGenericRecordToRowDataMapper(rowType);
    }
}

