/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.maintenance.api.DeleteOrphanFiles;
import org.apache.iceberg.flink.maintenance.api.Trigger;
import org.apache.iceberg.flink.maintenance.operator.TableMaintenanceMetrics;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.SupportsPrefixOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.FileSystemWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ListFileSystemFiles
extends ProcessFunction<Trigger, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ListFileSystemFiles.class);
    private final String taskName;
    private final int taskIndex;
    private FileIO io;
    private Map<Integer, PartitionSpec> specs;
    private String location;
    private final long minAgeMs;
    private transient Counter errorCounter;
    private final TableLoader tableLoader;
    private final boolean usePrefixListing;
    private transient Configuration configuration;

    public ListFileSystemFiles(String taskName, int taskIndex, TableLoader tableLoader, String location, long minAgeMs, boolean usePrefixListing) {
        Preconditions.checkNotNull(taskName, "Task name should no be null");
        Preconditions.checkNotNull(tableLoader, "TableLoad should no be null");
        this.tableLoader = tableLoader;
        this.taskName = taskName;
        this.taskIndex = taskIndex;
        this.minAgeMs = minAgeMs;
        this.location = location;
        this.usePrefixListing = usePrefixListing;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.tableLoader.open();
        Table table = this.tableLoader.loadTable();
        this.io = table.io();
        this.location = this.location != null ? this.location : table.location();
        this.specs = table.specs();
        this.errorCounter = TableMaintenanceMetrics.groupFor(this.getRuntimeContext(), table.name(), this.taskName, this.taskIndex).counter("error");
        this.configuration = new Configuration();
        table.properties().forEach((arg_0, arg_1) -> ((Configuration)this.configuration).set(arg_0, arg_1));
    }

    public void processElement(Trigger trigger, ProcessFunction.Context ctx, Collector<String> out) throws Exception {
        long olderThanTimestamp = trigger.timestamp() - this.minAgeMs;
        try {
            if (this.usePrefixListing) {
                Predicate<FileInfo> predicate = fileInfo -> fileInfo.createdAtMillis() < olderThanTimestamp;
                Preconditions.checkArgument(this.io instanceof SupportsPrefixOperations, "Cannot use prefix listing with FileIO {} which does not support prefix operations.", (Object)this.io);
                FileSystemWalker.listDirRecursivelyWithFileIO((SupportsPrefixOperations)this.io, this.location, this.specs, predicate, arg_0 -> out.collect(arg_0));
            } else {
                Predicate<FileStatus> predicate = file -> file.getModificationTime() < olderThanTimestamp;
                FileSystemWalker.listDirRecursivelyWithHadoop(this.location, this.specs, predicate, this.configuration, Integer.MAX_VALUE, Integer.MAX_VALUE, dir -> {}, arg_0 -> out.collect(arg_0));
            }
        }
        catch (Exception e) {
            LOG.warn("Exception listing files for {} at {}", new Object[]{this.location, ctx.timestamp(), e});
            ctx.output(DeleteOrphanFiles.ERROR_STREAM, (Object)e);
            this.errorCounter.inc();
        }
    }

    public void close() throws Exception {
        super.close();
        this.tableLoader.close();
    }
}

