/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import org.apache.flink.annotation.Internal;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

public class Trigger {
    private final long timestamp;
    private final Integer taskId;
    private final boolean isRecovery;

    private Trigger(long timestamp, Integer taskId, boolean isRecovery) {
        this.timestamp = timestamp;
        this.taskId = taskId;
        this.isRecovery = isRecovery;
    }

    @Internal
    public static Trigger create(long timestamp, int taskId) {
        return new Trigger(timestamp, taskId, false);
    }

    @Internal
    public static Trigger recovery(long timestamp) {
        return new Trigger(timestamp, null, true);
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Integer taskId() {
        return this.taskId;
    }

    public boolean isRecovery() {
        return this.isRecovery;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("timestamp", this.timestamp).add("taskId", this.taskId).add("isRecovery", this.isRecovery).toString();
    }
}

