/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.maintenance.api.TaskResult;
import org.apache.iceberg.flink.maintenance.api.Trigger;
import org.apache.iceberg.flink.maintenance.operator.TriggerEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Experimental
public abstract class MaintenanceTaskBuilder<T extends MaintenanceTaskBuilder<?>> {
    private int index;
    private String taskName;
    private String tableName;
    private TableLoader tableLoader;
    private String uidSuffix = null;
    private String slotSharingGroup = null;
    private Integer parallelism = null;
    private final TriggerEvaluator.Builder triggerEvaluator = new TriggerEvaluator.Builder();

    abstract DataStream<TaskResult> append(DataStream<Trigger> var1);

    abstract String maintenanceTaskName();

    public T scheduleOnCommitCount(int commitCount) {
        this.triggerEvaluator.commitCount(commitCount);
        return (T)this;
    }

    public T scheduleOnDataFileCount(int dataFileCount) {
        this.triggerEvaluator.dataFileCount(dataFileCount);
        return (T)this;
    }

    public T scheduleOnDataFileSize(long dataFileSizeInBytes) {
        this.triggerEvaluator.dataFileSizeInBytes(dataFileSizeInBytes);
        return (T)this;
    }

    public T scheduleOnPosDeleteFileCount(int posDeleteFileCount) {
        this.triggerEvaluator.posDeleteFileCount(posDeleteFileCount);
        return (T)this;
    }

    public T scheduleOnPosDeleteRecordCount(long posDeleteRecordCount) {
        this.triggerEvaluator.posDeleteRecordCount(posDeleteRecordCount);
        return (T)this;
    }

    public T scheduleOnEqDeleteFileCount(int eqDeleteFileCount) {
        this.triggerEvaluator.eqDeleteFileCount(eqDeleteFileCount);
        return (T)this;
    }

    public T scheduleOnEqDeleteRecordCount(long eqDeleteRecordCount) {
        this.triggerEvaluator.eqDeleteRecordCount(eqDeleteRecordCount);
        return (T)this;
    }

    public T scheduleOnInterval(Duration interval) {
        this.triggerEvaluator.timeout(interval);
        return (T)this;
    }

    public T uidSuffix(String newUidSuffix) {
        this.uidSuffix = newUidSuffix;
        return (T)this;
    }

    public T slotSharingGroup(String newSlotSharingGroup) {
        this.slotSharingGroup = newSlotSharingGroup;
        return (T)this;
    }

    public T parallelism(int newParallelism) {
        OperatorValidationUtils.validateParallelism((int)newParallelism);
        this.parallelism = newParallelism;
        return (T)this;
    }

    protected int index() {
        return this.index;
    }

    protected String taskName() {
        return this.taskName;
    }

    protected String tableName() {
        return this.tableName;
    }

    protected TableLoader tableLoader() {
        return this.tableLoader;
    }

    protected String uidSuffix() {
        return this.uidSuffix;
    }

    protected String slotSharingGroup() {
        return this.slotSharingGroup;
    }

    protected Integer parallelism() {
        return this.parallelism;
    }

    protected String operatorName(String operatorNameBase) {
        return operatorNameBase + "[" + this.index() + "]";
    }

    TriggerEvaluator evaluator() {
        return this.triggerEvaluator.build();
    }

    DataStream<TaskResult> append(DataStream<Trigger> sourceStream, String newTableName, String newTaskName, int taskIndex, TableLoader newTableLoader, String defaultUidSuffix, String defaultSlotSharingGroup, int defaultParallelism) {
        Preconditions.checkNotNull(newTaskName, "Task name should not be null");
        Preconditions.checkNotNull(newTableLoader, "TableLoader should not be null");
        this.index = taskIndex;
        this.taskName = newTaskName;
        this.tableName = newTableName;
        this.tableLoader = newTableLoader;
        if (this.uidSuffix == null) {
            this.uidSuffix = this.taskName + "_" + this.index + "_" + defaultUidSuffix;
        }
        if (this.parallelism == null) {
            this.parallelism = defaultParallelism;
        }
        if (this.slotSharingGroup == null) {
            this.slotSharingGroup = defaultSlotSharingGroup;
        }
        return this.append(sourceStream);
    }
}

