/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.api;

import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.flink.maintenance.api.LockConfig;
import org.apache.iceberg.flink.maintenance.api.RewriteDataFilesConfig;

public class FlinkMaintenanceConfig {
    public static final String PREFIX = "flink-maintenance.";
    public static final String LOCK_CHECK_DELAY = "flink-maintenance.lock-check-delay-seconds";
    public static final ConfigOption<Long> LOCK_CHECK_DELAY_OPTION = ConfigOptions.key((String)"flink-maintenance.lock-check-delay-seconds").longType().defaultValue((Object)30L).withDescription("The delay time (in seconds) between each lock check during maintenance operations such as rewriting data files, manifest files, expiring snapshots, and deleting orphan files.");
    public static final String PARALLELISM = "flink-maintenance.parallelism";
    public static final ConfigOption<Integer> PARALLELISM_OPTION = ConfigOptions.key((String)"flink-maintenance.parallelism").intType().defaultValue((Object)-1).withDescription("The number of parallel tasks for the maintenance action.");
    public static final String RATE_LIMIT = "flink-maintenance.rate-limit-seconds";
    public static final ConfigOption<Long> RATE_LIMIT_OPTION = ConfigOptions.key((String)"flink-maintenance.rate-limit-seconds").longType().defaultValue((Object)60L).withDescription("The rate limit (in seconds) for maintenance operations. This controls how many operations can be performed per second.");
    public static final String SLOT_SHARING_GROUP = "flink-maintenance.slot-sharing-group";
    public static final ConfigOption<String> SLOT_SHARING_GROUP_OPTION = ConfigOptions.key((String)"flink-maintenance.slot-sharing-group").stringType().defaultValue((Object)"default").withDescription("The slot sharing group for maintenance tasks. Determines which operators can share slots in the Flink execution environment.");
    private final FlinkConfParser confParser;
    private final Table table;
    private final Map<String, String> writeProperties;
    private final ReadableConfig readableConfig;

    public FlinkMaintenanceConfig(Table table, Map<String, String> writeOptions, ReadableConfig readableConfig) {
        this.table = table;
        this.readableConfig = readableConfig;
        this.writeProperties = writeOptions;
        this.confParser = new FlinkConfParser(table, writeOptions, readableConfig);
    }

    public long rateLimit() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(RATE_LIMIT)).flinkConfig(RATE_LIMIT_OPTION)).defaultValue((Long)RATE_LIMIT_OPTION.defaultValue()).parse();
    }

    public int parallelism() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(PARALLELISM)).flinkConfig(PARALLELISM_OPTION)).defaultValue((Integer)PARALLELISM_OPTION.defaultValue()).parse();
    }

    public long lockCheckDelay() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option(LOCK_CHECK_DELAY)).flinkConfig(LOCK_CHECK_DELAY_OPTION)).defaultValue((Long)LOCK_CHECK_DELAY_OPTION.defaultValue()).parse();
    }

    public String slotSharingGroup() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(SLOT_SHARING_GROUP)).flinkConfig(SLOT_SHARING_GROUP_OPTION)).defaultValue((String)SLOT_SHARING_GROUP_OPTION.defaultValue()).parse();
    }

    public RewriteDataFilesConfig createRewriteDataFilesConfig() {
        return new RewriteDataFilesConfig(this.table, this.writeProperties, this.readableConfig);
    }

    public LockConfig createLockConfig() {
        return new LockConfig(this.table, this.writeProperties, this.readableConfig);
    }
}

