/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.StringUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkRowData;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;

public class RowDataProjection
implements RowData {
    private final RowData.FieldGetter[] getters;
    private RowData rowData;

    public static RowDataProjection create(Schema schema, Schema projectedSchema) {
        return RowDataProjection.create(FlinkSchemaUtil.convert(schema), schema.asStruct(), projectedSchema.asStruct());
    }

    public static RowDataProjection create(RowType rowType, Types.StructType schema, Types.StructType projectedSchema) {
        return new RowDataProjection(rowType, schema, projectedSchema);
    }

    private RowDataProjection(RowType rowType, Types.StructType rowStruct, Types.StructType projectType) {
        int i;
        HashMap<Integer, Integer> fieldIdToPosition = Maps.newHashMap();
        for (i = 0; i < rowStruct.fields().size(); ++i) {
            fieldIdToPosition.put(rowStruct.fields().get(i).fieldId(), i);
        }
        this.getters = new RowData.FieldGetter[projectType.fields().size()];
        for (i = 0; i < this.getters.length; ++i) {
            Types.NestedField projectField = projectType.fields().get(i);
            Types.NestedField rowField = rowStruct.field(projectField.fieldId());
            Preconditions.checkNotNull(rowField, "Cannot locate the project field <%s> in the iceberg struct <%s>", (Object)projectField, (Object)rowStruct);
            this.getters[i] = RowDataProjection.createFieldGetter(rowType, (Integer)fieldIdToPosition.get(projectField.fieldId()), rowField, projectField);
        }
    }

    private static RowData.FieldGetter createFieldGetter(RowType rowType, int position, Types.NestedField rowField, Types.NestedField projectField) {
        Preconditions.checkArgument(rowField.type().typeId() == projectField.type().typeId(), "Different iceberg type between row field <%s> and project field <%s>", (Object)rowField, (Object)projectField);
        switch (projectField.type().typeId()) {
            case STRUCT: {
                RowType nestedRowType = (RowType)rowType.getTypeAt(position);
                return (RowData.FieldGetter & Serializable)row -> {
                    if (row.isNullAt(position)) {
                        return null;
                    }
                    RowData nestedRow = row.getRow(position, nestedRowType.getFieldCount());
                    return RowDataProjection.create(nestedRowType, rowField.type().asStructType(), projectField.type().asStructType()).wrap(nestedRow);
                };
            }
            case MAP: {
                Types.MapType projectedMap = projectField.type().asMapType();
                Types.MapType originalMap = rowField.type().asMapType();
                boolean keyProjectable = !projectedMap.keyType().isNestedType() || projectedMap.keyType().equals(originalMap.keyType());
                boolean valueProjectable = !projectedMap.valueType().isNestedType() || projectedMap.valueType().equals(originalMap.valueType());
                Preconditions.checkArgument(keyProjectable && valueProjectable, "Cannot project a partial map key or value with non-primitive type. Trying to project <%s> out of <%s>", (Object)projectField, (Object)rowField);
                return FlinkRowData.createFieldGetter(rowType.getTypeAt(position), position);
            }
            case LIST: {
                Types.ListType projectedList = projectField.type().asListType();
                Types.ListType originalList = rowField.type().asListType();
                boolean elementProjectable = !projectedList.elementType().isNestedType() || projectedList.elementType().equals(originalList.elementType());
                Preconditions.checkArgument(elementProjectable, "Cannot project a partial list element with non-primitive type. Trying to project <%s> out of <%s>", (Object)projectField, (Object)rowField);
                return FlinkRowData.createFieldGetter(rowType.getTypeAt(position), position);
            }
        }
        return FlinkRowData.createFieldGetter(rowType.getTypeAt(position), position);
    }

    public RowData wrap(RowData row) {
        Preconditions.checkArgument(row != null, "Invalid row data: null");
        this.rowData = row;
        return this;
    }

    private Object getValue(int pos) {
        Preconditions.checkState(this.rowData != null, "Row data not wrapped");
        return this.getters[pos].getFieldOrNull(this.rowData);
    }

    public int getArity() {
        return this.getters.length;
    }

    public RowKind getRowKind() {
        Preconditions.checkState(this.rowData != null, "Row data not wrapped");
        return this.rowData.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        throw new UnsupportedOperationException("Cannot set row kind in the RowDataProjection");
    }

    public boolean isNullAt(int pos) {
        return this.getValue(pos) == null;
    }

    public boolean getBoolean(int pos) {
        return (Boolean)this.getValue(pos);
    }

    public byte getByte(int pos) {
        return (Byte)this.getValue(pos);
    }

    public short getShort(int pos) {
        return (Short)this.getValue(pos);
    }

    public int getInt(int pos) {
        return (Integer)this.getValue(pos);
    }

    public long getLong(int pos) {
        return (Long)this.getValue(pos);
    }

    public float getFloat(int pos) {
        return ((Float)this.getValue(pos)).floatValue();
    }

    public double getDouble(int pos) {
        return (Double)this.getValue(pos);
    }

    public StringData getString(int pos) {
        return (StringData)this.getValue(pos);
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return (DecimalData)this.getValue(pos);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return (TimestampData)this.getValue(pos);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return (RawValueData)this.getValue(pos);
    }

    public byte[] getBinary(int pos) {
        return (byte[])this.getValue(pos);
    }

    public ArrayData getArray(int pos) {
        return (ArrayData)this.getValue(pos);
    }

    public MapData getMap(int pos) {
        return (MapData)this.getValue(pos);
    }

    public RowData getRow(int pos, int numFields) {
        return (RowData)this.getValue(pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowDataProjection)) {
            return false;
        }
        RowDataProjection that = (RowDataProjection)o;
        return this.deepEquals(that);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getRowKind());
        for (int pos = 0; pos < this.getArity(); ++pos) {
            if (this.isNullAt(pos)) continue;
            result = 31 * result + Arrays.deepHashCode(new Object[]{this.getValue(pos)});
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRowKind().shortString()).append("(");
        for (int pos = 0; pos < this.getArity(); ++pos) {
            if (pos != 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString((Object)this.getValue(pos)));
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean deepEquals(RowDataProjection other) {
        if (this.getRowKind() != other.getRowKind()) {
            return false;
        }
        if (this.getArity() != other.getArity()) {
            return false;
        }
        for (int pos = 0; pos < this.getArity(); ++pos) {
            if (this.isNullAt(pos) && other.isNullAt(pos)) continue;
            if (this.isNullAt(pos) && !other.isNullAt(pos) || !this.isNullAt(pos) && other.isNullAt(pos)) {
                return false;
            }
            if (Objects.deepEquals(this.getValue(pos), other.getValue(pos))) continue;
            return false;
        }
        return true;
    }
}

