/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.TimeUtils;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfParser;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.FlinkReadOptions;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;

public class FlinkReadConf {
    private final FlinkConfParser confParser;

    public FlinkReadConf(Table table, Map<String, String> readOptions, ReadableConfig readableConfig) {
        this.confParser = new FlinkConfParser(table, readOptions, readableConfig);
    }

    public Long snapshotId() {
        return ((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkReadOptions.SNAPSHOT_ID.key())).parseOptional();
    }

    public String tag() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkReadOptions.TAG.key())).parseOptional();
    }

    public String startTag() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkReadOptions.START_TAG.key())).parseOptional();
    }

    public String endTag() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkReadOptions.END_TAG.key())).parseOptional();
    }

    public String branch() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option(FlinkReadOptions.BRANCH.key())).parseOptional();
    }

    public boolean caseSensitive() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option("case-sensitive")).flinkConfig(FlinkReadOptions.CASE_SENSITIVE_OPTION)).defaultValue((Boolean)FlinkReadOptions.CASE_SENSITIVE_OPTION.defaultValue()).parse();
    }

    public Long asOfTimestamp() {
        return ((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkReadOptions.AS_OF_TIMESTAMP.key())).parseOptional();
    }

    public StreamingStartingStrategy startingStrategy() {
        return ((FlinkConfParser.EnumConfParser)((FlinkConfParser.EnumConfParser)this.confParser.enumConfParser(StreamingStartingStrategy.class).option("starting-strategy")).flinkConfig(FlinkReadOptions.STARTING_STRATEGY_OPTION)).defaultValue(StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT).parse();
    }

    public Long startSnapshotTimestamp() {
        return ((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkReadOptions.START_SNAPSHOT_TIMESTAMP.key())).parseOptional();
    }

    public Long startSnapshotId() {
        return ((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkReadOptions.START_SNAPSHOT_ID.key())).parseOptional();
    }

    public Long endSnapshotId() {
        return ((FlinkConfParser.LongConfParser)this.confParser.longConf().option(FlinkReadOptions.END_SNAPSHOT_ID.key())).parseOptional();
    }

    public long splitSize() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option("split-size")).flinkConfig(FlinkReadOptions.SPLIT_SIZE_OPTION)).tableProperty("read.split.target-size")).defaultValue(0x8000000L).parse();
    }

    public int splitLookback() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option("split-lookback")).flinkConfig(FlinkReadOptions.SPLIT_LOOKBACK_OPTION)).tableProperty("read.split.planning-lookback")).defaultValue(10).parse();
    }

    public long splitFileOpenCost() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option("split-file-open-cost")).flinkConfig(FlinkReadOptions.SPLIT_FILE_OPEN_COST_OPTION)).tableProperty("read.split.open-file-cost")).defaultValue(0x400000L).parse();
    }

    public boolean streaming() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option("streaming")).flinkConfig(FlinkReadOptions.STREAMING_OPTION)).defaultValue((Boolean)FlinkReadOptions.STREAMING_OPTION.defaultValue()).parse();
    }

    public Duration monitorInterval() {
        String duration = ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option("monitor-interval")).flinkConfig(FlinkReadOptions.MONITOR_INTERVAL_OPTION)).defaultValue((String)FlinkReadOptions.MONITOR_INTERVAL_OPTION.defaultValue()).parse();
        return TimeUtils.parseDuration((String)duration);
    }

    public boolean includeColumnStats() {
        return ((FlinkConfParser.BooleanConfParser)((FlinkConfParser.BooleanConfParser)this.confParser.booleanConf().option("include-column-stats")).flinkConfig(FlinkReadOptions.INCLUDE_COLUMN_STATS_OPTION)).defaultValue((Boolean)FlinkReadOptions.INCLUDE_COLUMN_STATS_OPTION.defaultValue()).parse();
    }

    public int maxPlanningSnapshotCount() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option("max-planning-snapshot-count")).flinkConfig(FlinkReadOptions.MAX_PLANNING_SNAPSHOT_COUNT_OPTION)).defaultValue((Integer)FlinkReadOptions.MAX_PLANNING_SNAPSHOT_COUNT_OPTION.defaultValue()).parse();
    }

    public String nameMapping() {
        return ((FlinkConfParser.StringConfParser)this.confParser.stringConf().option("schema.name-mapping.default")).parseOptional();
    }

    public long limit() {
        return ((FlinkConfParser.LongConfParser)((FlinkConfParser.LongConfParser)this.confParser.longConf().option("limit")).flinkConfig(FlinkReadOptions.LIMIT_OPTION)).defaultValue((Long)FlinkReadOptions.LIMIT_OPTION.defaultValue()).parse();
    }

    public int workerPoolSize() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option(FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE.key())).flinkConfig(FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE)).defaultValue((Integer)FlinkConfigOptions.TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE.defaultValue()).parse();
    }

    public int maxAllowedPlanningFailures() {
        return ((FlinkConfParser.IntConfParser)((FlinkConfParser.IntConfParser)this.confParser.intConf().option("max-allowed-planning-failures")).flinkConfig(FlinkReadOptions.MAX_ALLOWED_PLANNING_FAILURES_OPTION)).defaultValue((Integer)FlinkReadOptions.MAX_ALLOWED_PLANNING_FAILURES_OPTION.defaultValue()).parse();
    }

    public String watermarkColumn() {
        return ((FlinkConfParser.StringConfParser)((FlinkConfParser.StringConfParser)this.confParser.stringConf().option("watermark-column")).flinkConfig(FlinkReadOptions.WATERMARK_COLUMN_OPTION)).defaultValue((String)FlinkReadOptions.WATERMARK_COLUMN_OPTION.defaultValue()).parseOptional();
    }

    public TimeUnit watermarkColumnTimeUnit() {
        return ((FlinkConfParser.EnumConfParser)((FlinkConfParser.EnumConfParser)this.confParser.enumConfParser(TimeUnit.class).option("watermark-column-time-unit")).flinkConfig(FlinkReadOptions.WATERMARK_COLUMN_TIME_UNIT_OPTION)).defaultValue((TimeUnit)((Object)FlinkReadOptions.WATERMARK_COLUMN_TIME_UNIT_OPTION.defaultValue())).parse();
    }
}

