/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.iceberg.util.JsonUtil;

class FlinkCreateTableOptions {
    private final String catalogName;
    private final String catalogDb;
    private final String catalogTable;
    private final Map<String, String> catalogProps;
    public static final ConfigOption<String> CATALOG_NAME = ConfigOptions.key((String)"catalog-name").stringType().noDefaultValue().withDescription("Catalog name");
    public static final ConfigOption<String> CATALOG_TYPE = ConfigOptions.key((String)"catalog-type").stringType().noDefaultValue().withDescription("Catalog type, the optional types are: custom, hadoop, hive.");
    public static final ConfigOption<String> CATALOG_DATABASE = ConfigOptions.key((String)"catalog-database").stringType().defaultValue((Object)"default").withDescription("Database name managed in the iceberg catalog.");
    public static final ConfigOption<String> CATALOG_TABLE = ConfigOptions.key((String)"catalog-table").stringType().noDefaultValue().withDescription("Table name managed in the underlying iceberg catalog and database.");
    public static final ConfigOption<Map<String, String>> CATALOG_PROPS = ConfigOptions.key((String)"catalog-props").mapType().noDefaultValue().withDescription("Properties for the underlying catalog for iceberg table.");
    public static final String SRC_CATALOG_PROPS_KEY = "src-catalog";
    public static final String CONNECTOR_PROPS_KEY = "connector";
    public static final String LOCATION_KEY = "location";

    private FlinkCreateTableOptions(String catalogName, String catalogDb, String catalogTable, Map<String, String> props) {
        this.catalogName = catalogName;
        this.catalogDb = catalogDb;
        this.catalogTable = catalogTable;
        this.catalogProps = props;
    }

    static String toJson(String catalogName, String catalogDb, String catalogTable, Map<String, String> catalogProps) {
        return JsonUtil.generate(gen -> {
            gen.writeStartObject();
            gen.writeStringField(CATALOG_NAME.key(), catalogName);
            gen.writeStringField(CATALOG_DATABASE.key(), catalogDb);
            gen.writeStringField(CATALOG_TABLE.key(), catalogTable);
            JsonUtil.writeStringMap(CATALOG_PROPS.key(), catalogProps, gen);
            gen.writeEndObject();
        }, false);
    }

    static FlinkCreateTableOptions fromJson(String createTableOptions) {
        return JsonUtil.parse(createTableOptions, node -> {
            String catalogName = JsonUtil.getString(CATALOG_NAME.key(), node);
            String catalogDb = JsonUtil.getString(CATALOG_DATABASE.key(), node);
            String catalogTable = JsonUtil.getString(CATALOG_TABLE.key(), node);
            Map<String, String> catalogProps = JsonUtil.getStringMap(CATALOG_PROPS.key(), node);
            return new FlinkCreateTableOptions(catalogName, catalogDb, catalogTable, catalogProps);
        });
    }

    String catalogName() {
        return this.catalogName;
    }

    String catalogDb() {
        return this.catalogDb;
    }

    String catalogTable() {
        return this.catalogTable;
    }

    Map<String, String> catalogProps() {
        return this.catalogProps;
    }
}

