/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.iceberg.flink.source.assigner.SplitAssignerType;
import org.apache.iceberg.util.ThreadPools;

public class FlinkConfigOptions {
    public static final ConfigOption<Boolean> TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM = ConfigOptions.key((String)"table.exec.iceberg.infer-source-parallelism").booleanType().defaultValue((Object)true).withDescription("If is false, parallelism of source are set by config.\nIf is true, source parallelism is inferred according to splits number.\n");
    public static final ConfigOption<Integer> TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX = ConfigOptions.key((String)"table.exec.iceberg.infer-source-parallelism.max").intType().defaultValue((Object)100).withDescription("Sets max infer parallelism for source operator.");
    public static final ConfigOption<Boolean> TABLE_EXEC_ICEBERG_EXPOSE_SPLIT_LOCALITY_INFO = ConfigOptions.key((String)"table.exec.iceberg.expose-split-locality-info").booleanType().noDefaultValue().withDescription("Expose split host information to use Flink's locality aware split assigner.");
    public static final ConfigOption<Integer> SOURCE_READER_FETCH_BATCH_RECORD_COUNT = ConfigOptions.key((String)"table.exec.iceberg.fetch-batch-record-count").intType().defaultValue((Object)2048).withDescription("The target number of records for Iceberg reader fetch batch.");
    public static final ConfigOption<Integer> TABLE_EXEC_ICEBERG_WORKER_POOL_SIZE = ConfigOptions.key((String)"table.exec.iceberg.worker-pool-size").intType().defaultValue((Object)ThreadPools.WORKER_THREAD_POOL_SIZE).withDescription("The size of workers pool used to plan or scan manifests.");
    public static final ConfigOption<Boolean> TABLE_EXEC_ICEBERG_USE_FLIP27_SOURCE = ConfigOptions.key((String)"table.exec.iceberg.use-flip27-source").booleanType().defaultValue((Object)true).withDescription("Use the FLIP-27 based Iceberg source implementation.");
    public static final ConfigOption<Boolean> TABLE_EXEC_ICEBERG_USE_V2_SINK = ConfigOptions.key((String)"table.exec.iceberg.use-v2-sink").booleanType().defaultValue((Object)false).withDescription("Use the SinkV2 API based Iceberg sink implementation.");
    public static final ConfigOption<SplitAssignerType> TABLE_EXEC_SPLIT_ASSIGNER_TYPE = ConfigOptions.key((String)"table.exec.iceberg.split-assigner-type").enumType(SplitAssignerType.class).defaultValue((Object)SplitAssignerType.SIMPLE).withDescription(Description.builder().text("Split assigner type that determine how splits are assigned to readers.").linebreak().list(new InlineElement[]{TextElement.text((String)(String.valueOf((Object)SplitAssignerType.SIMPLE) + ": simple assigner that doesn't provide any guarantee on order or locality."))}).build());

    private FlinkConfigOptions() {
    }
}

