/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.parquet.BaseParquetWriter;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.types.Types;

public class InternalWriter<T extends StructLike>
extends BaseParquetWriter<T> {
    private static final InternalWriter<?> INSTANCE = new InternalWriter();

    private InternalWriter() {
    }

    public static <T extends StructLike> ParquetValueWriter<T> createWriter(Schema schema, MessageType type) {
        return InternalWriter.create(schema.asStruct(), type);
    }

    public static <T extends StructLike> ParquetValueWriter<T> create(Types.StructType struct, MessageType type) {
        return INSTANCE.createWriter(struct, type);
    }

    @Override
    protected ParquetValueWriters.StructWriter<T> createStructWriter(Types.StructType struct, List<ParquetValueWriter<?>> writers) {
        return ParquetValueWriters.recordWriter(struct, writers);
    }

    @Override
    protected ParquetValueWriter<?> fixedWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.fixedBuffers(desc);
    }

    @Override
    protected ParquetValueWriter<?> dateWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.ints(desc);
    }

    @Override
    protected ParquetValueWriter<?> timeWriter(ColumnDescriptor desc) {
        return ParquetValueWriters.longs(desc);
    }

    @Override
    protected ParquetValueWriter<?> timestampWriter(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        return ParquetValueWriters.longs(desc);
    }
}

