/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.data.avro.GenericWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;

public class DataWriter<T>
implements MetricsAwareDatumWriter<T> {
    private ValueWriter<T> writer = null;

    public static <D> DataWriter<D> create(Schema schema) {
        return new DataWriter(schema);
    }

    protected DataWriter(Schema schema) {
        this.setSchema(schema);
    }

    @Override
    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroSchemaVisitor.visit(schema, new WriteBuilder());
    }

    @Override
    public void write(T datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    protected ValueWriter<?> createStructWriter(List<ValueWriter<?>> fields) {
        return GenericWriters.struct(fields);
    }

    @Override
    public Stream<FieldMetrics> metrics() {
        return this.writer.metrics();
    }

    private class WriteBuilder
    extends AvroSchemaVisitor<ValueWriter<?>> {
        private WriteBuilder() {
        }

        @Override
        public ValueWriter<?> record(Schema record, List<String> names, List<ValueWriter<?>> fields) {
            return DataWriter.this.createStructWriter(fields);
        }

        @Override
        public ValueWriter<?> union(Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument(options.contains(ValueWriters.nulls()), "Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument(options.size() == 2, "Cannot create writer for non-option union: %s", (Object)union);
            if (union.getTypes().get(0).getType() == Schema.Type.NULL) {
                return ValueWriters.option(0, options.get(1));
            }
            return ValueWriters.option(1, options.get(0));
        }

        @Override
        public ValueWriter<?> array(Schema array, ValueWriter<?> elementWriter) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueWriters.StructWriter keyValueWriter = (ValueWriters.StructWriter)elementWriter;
                return ValueWriters.arrayMap(keyValueWriter.writer(0), keyValueWriter.writer(1));
            }
            return ValueWriters.array(elementWriter);
        }

        @Override
        public ValueWriter<?> map(Schema map, ValueWriter<?> valueWriter) {
            return ValueWriters.map(ValueWriters.strings(), valueWriter);
        }

        @Override
        public ValueWriter<?> variant(Schema variant, ValueWriter<?> metadataWriter, ValueWriter<?> valueWriter) {
            return ValueWriters.variants();
        }

        @Override
        public ValueWriter<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericWriters.dates();
                    }
                    case "time-micros": {
                        return GenericWriters.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz(primitive)) {
                            return GenericWriters.timestamptz();
                        }
                        return GenericWriters.timestamps();
                    }
                    case "timestamp-nanos": {
                        if (AvroSchemaUtil.isTimestamptz(primitive)) {
                            return GenericWriters.timestamptzNanos();
                        }
                        return GenericWriters.timestampNanos();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueWriters.decimal(decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return ValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + String.valueOf(logicalType));
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return ValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(primitive));
        }
    }
}

