/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.BaseDeleteLoader;
import org.apache.iceberg.data.DeleteLoader;
import org.apache.iceberg.deletes.DeleteCounter;
import org.apache.iceberg.deletes.Deletes;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteFilter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteFilter.class);
    private final String filePath;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private final Schema requiredSchema;
    private final Schema expectedSchema;
    private final Accessor<StructLike> posAccessor;
    private final boolean hasIsDeletedColumn;
    private final int isDeletedColumnPosition;
    private final DeleteCounter counter;
    private volatile DeleteLoader deleteLoader = null;
    private PositionDeleteIndex deleteRowPositions = null;
    private List<Predicate<T>> isInDeleteSets = null;
    private Predicate<T> eqDeleteRows = null;

    protected DeleteFilter(String filePath, List<DeleteFile> deletes, Schema tableSchema, Schema expectedSchema, DeleteCounter counter, boolean needRowPosCol) {
        this.filePath = filePath;
        this.counter = counter;
        this.expectedSchema = expectedSchema;
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        block4: for (DeleteFile delete : deletes) {
            switch (delete.content()) {
                case POSITION_DELETES: {
                    LOG.debug("Adding position delete file {} to filter", (Object)delete.location());
                    posDeleteBuilder.add(delete);
                    continue block4;
                }
                case EQUALITY_DELETES: {
                    LOG.debug("Adding equality delete file {} to filter", (Object)delete.location());
                    eqDeleteBuilder.add(delete);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown delete file content: " + String.valueOf((Object)delete.content()));
        }
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.requiredSchema = DeleteFilter.fileProjection(tableSchema, expectedSchema, this.posDeletes, this.eqDeletes, needRowPosCol);
        this.posAccessor = this.requiredSchema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
        this.hasIsDeletedColumn = this.requiredSchema.findField(MetadataColumns.IS_DELETED.fieldId()) != null;
        this.isDeletedColumnPosition = this.requiredSchema.columns().indexOf(MetadataColumns.IS_DELETED);
    }

    protected DeleteFilter(String filePath, List<DeleteFile> deletes, Schema tableSchema, Schema requestedSchema, DeleteCounter counter) {
        this(filePath, deletes, tableSchema, requestedSchema, counter, true);
    }

    protected DeleteFilter(String filePath, List<DeleteFile> deletes, Schema tableSchema, Schema requestedSchema) {
        this(filePath, deletes, tableSchema, requestedSchema, new DeleteCounter());
    }

    protected int columnIsDeletedPosition() {
        return this.isDeletedColumnPosition;
    }

    public Schema requiredSchema() {
        return this.requiredSchema;
    }

    public Schema expectedSchema() {
        return this.expectedSchema;
    }

    public boolean hasPosDeletes() {
        return !this.posDeletes.isEmpty();
    }

    public boolean hasEqDeletes() {
        return !this.eqDeletes.isEmpty();
    }

    public void incrementDeleteCount() {
        this.counter.increment();
    }

    Accessor<StructLike> posAccessor() {
        return this.posAccessor;
    }

    protected abstract StructLike asStructLike(T var1);

    protected abstract InputFile getInputFile(String var1);

    protected InputFile loadInputFile(DeleteFile deleteFile) {
        return this.getInputFile(deleteFile.location());
    }

    protected long pos(T record) {
        return (Long)this.posAccessor.get(this.asStructLike(record));
    }

    protected DeleteLoader newDeleteLoader() {
        return new BaseDeleteLoader(this::loadInputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteLoader deleteLoader() {
        if (this.deleteLoader == null) {
            DeleteFilter deleteFilter = this;
            synchronized (deleteFilter) {
                if (this.deleteLoader == null) {
                    this.deleteLoader = this.newDeleteLoader();
                }
            }
        }
        return this.deleteLoader;
    }

    public CloseableIterable<T> filter(CloseableIterable<T> records) {
        return this.applyEqDeletes(this.applyPosDeletes(records));
    }

    private List<Predicate<T>> applyEqDeletes() {
        if (this.isInDeleteSets != null) {
            return this.isInDeleteSets;
        }
        this.isInDeleteSets = Lists.newArrayList();
        if (this.eqDeletes.isEmpty()) {
            return this.isInDeleteSets;
        }
        Multimap<HashSet<Integer>, DeleteFile> filesByDeleteIds = Multimaps.newMultimap(Maps.newHashMap(), Lists::newArrayList);
        for (DeleteFile deleteFile : this.eqDeletes) {
            filesByDeleteIds.put(Sets.newHashSet(deleteFile.equalityFieldIds()), deleteFile);
        }
        for (Map.Entry entry : filesByDeleteIds.asMap().entrySet()) {
            Set ids = (Set)entry.getKey();
            Iterable deletes = (Iterable)entry.getValue();
            Schema deleteSchema = TypeUtil.select(this.requiredSchema, (Set<Integer>)ids);
            StructProjection projectRow = StructProjection.create(this.requiredSchema, deleteSchema);
            StructLikeSet deleteSet = this.deleteLoader().loadEqualityDeletes(deletes, deleteSchema);
            Predicate<Object> isInDeleteSet = record -> deleteSet.contains(projectRow.wrap(this.asStructLike(record)));
            this.isInDeleteSets.add(isInDeleteSet);
        }
        return this.isInDeleteSets;
    }

    public CloseableIterable<T> findEqualityDeleteRows(CloseableIterable<T> records) {
        Predicate<Object> deletedRows = this.applyEqDeletes().stream().reduce(Predicate::or).orElse(t2 -> false);
        return CloseableIterable.filter(records, deletedRows);
    }

    private CloseableIterable<T> applyEqDeletes(CloseableIterable<T> records) {
        Predicate<Object> isEqDeleted = this.applyEqDeletes().stream().reduce(Predicate::or).orElse(t2 -> false);
        return this.createDeleteIterable(records, isEqDeleted);
    }

    protected void markRowDeleted(T item) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement markRowDeleted");
    }

    public Predicate<T> eqDeletedRowFilter() {
        if (this.eqDeleteRows == null) {
            this.eqDeleteRows = this.applyEqDeletes().stream().map(Predicate::negate).reduce(Predicate::and).orElse(t2 -> true);
        }
        return this.eqDeleteRows;
    }

    public PositionDeleteIndex deletedRowPositions() {
        if (this.deleteRowPositions == null && !this.posDeletes.isEmpty()) {
            this.deleteRowPositions = this.deleteLoader().loadPositionDeletes(this.posDeletes, this.filePath);
        }
        return this.deleteRowPositions;
    }

    private CloseableIterable<T> applyPosDeletes(CloseableIterable<T> records) {
        if (this.posDeletes.isEmpty()) {
            return records;
        }
        PositionDeleteIndex positionIndex = this.deletedRowPositions();
        Predicate<Object> isDeleted = record -> positionIndex.isDeleted(this.pos(record));
        return this.createDeleteIterable(records, isDeleted);
    }

    private CloseableIterable<T> createDeleteIterable(CloseableIterable<T> records, Predicate<T> isDeleted) {
        return this.hasIsDeletedColumn ? Deletes.markDeleted(records, isDeleted, this::markRowDeleted) : Deletes.filterDeleted(records, isDeleted, this.counter);
    }

    private static Schema fileProjection(Schema tableSchema, Schema requestedSchema, List<DeleteFile> posDeletes, List<DeleteFile> eqDeletes, boolean needRowPosCol) {
        if (posDeletes.isEmpty() && eqDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet<Integer> requiredIds = Sets.newLinkedHashSet();
        if (needRowPosCol && !posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        for (DeleteFile eqDelete : eqDeletes) {
            requiredIds.addAll(eqDelete.equalityFieldIds());
        }
        LinkedHashSet missingIds = Sets.newLinkedHashSet(Sets.difference(requiredIds, TypeUtil.getProjectedIds(requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList<Types.NestedField> columns = Lists.newArrayList(requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.IS_DELETED.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument(field != null, "Cannot find required field for ID %s", fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(MetadataColumns.IS_DELETED.fieldId())) {
            columns.add(MetadataColumns.IS_DELETED);
        }
        return new Schema(columns);
    }
}

