/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.SimpleTokenCache;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthManagers;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.util.SerializableMap;
import reactor.core.publisher.Mono;

public class VendedAdlsCredentialProvider
implements Serializable,
AutoCloseable {
    public static final String URI = "credentials.uri";
    private final SerializableMap<String, String> properties;
    private final String credentialsEndpoint;
    private final String catalogEndpoint;
    private volatile transient Map<String, SimpleTokenCache> sasCredentialByAccount;
    private volatile transient HTTPClient client;
    private transient AuthManager authManager;
    private transient AuthSession authSession;

    public VendedAdlsCredentialProvider(Map<String, String> properties) {
        Preconditions.checkArgument(null != properties, "Invalid properties: null");
        Preconditions.checkArgument(null != properties.get(URI), "Invalid credentials endpoint: null");
        Preconditions.checkArgument(null != properties.get("uri"), "Invalid catalog endpoint: null");
        this.properties = SerializableMap.copyOf(properties);
        this.credentialsEndpoint = properties.get(URI);
        this.catalogEndpoint = properties.get("uri");
    }

    Mono<String> credentialForAccount(String storageAccount) {
        return this.sasCredentialByAccount().computeIfAbsent(storageAccount, ignored -> new SimpleTokenCache(() -> Mono.fromSupplier(() -> this.sasTokenForAccount(storageAccount)))).getToken().map(AccessToken::getToken);
    }

    private AccessToken sasTokenForAccount(String storageAccount) {
        LoadCredentialsResponse response = this.fetchCredentials();
        List adlsCredentials = response.credentials().stream().filter(c -> c.prefix().contains(storageAccount)).collect(Collectors.toList());
        Preconditions.checkState(!adlsCredentials.isEmpty(), String.format("Invalid ADLS Credentials for storage-account %s: empty", storageAccount));
        Preconditions.checkState(adlsCredentials.size() == 1, "Invalid ADLS Credentials: only one ADLS credential should exist per storage-account");
        Credential adlsCredential = (Credential)adlsCredentials.get(0);
        this.checkCredential(adlsCredential, "adls.sas-token." + storageAccount);
        this.checkCredential(adlsCredential, "adls.sas-token-expires-at-ms." + storageAccount);
        String sasToken = adlsCredential.config().get("adls.sas-token." + storageAccount);
        Instant tokenExpiresAt = Instant.ofEpochMilli(Long.parseLong(adlsCredential.config().get("adls.sas-token-expires-at-ms." + storageAccount)));
        return new AccessToken(sasToken, tokenExpiresAt.atOffset(ZoneOffset.UTC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SimpleTokenCache> sasCredentialByAccount() {
        if (this.sasCredentialByAccount == null) {
            VendedAdlsCredentialProvider vendedAdlsCredentialProvider = this;
            synchronized (vendedAdlsCredentialProvider) {
                if (this.sasCredentialByAccount == null) {
                    this.sasCredentialByAccount = Maps.newConcurrentMap();
                }
            }
        }
        return this.sasCredentialByAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RESTClient httpClient() {
        if (null == this.client) {
            VendedAdlsCredentialProvider vendedAdlsCredentialProvider = this;
            synchronized (vendedAdlsCredentialProvider) {
                if (null == this.client) {
                    this.authManager = AuthManagers.loadAuthManager("adls-credentials-refresh", this.properties);
                    HTTPClient httpClient = HTTPClient.builder(this.properties).uri(this.catalogEndpoint).build();
                    this.authSession = this.authManager.catalogSession(httpClient, this.properties);
                    this.client = httpClient.withAuthSession(this.authSession);
                }
            }
        }
        return this.client;
    }

    private LoadCredentialsResponse fetchCredentials() {
        return this.httpClient().get(this.credentialsEndpoint, null, LoadCredentialsResponse.class, Map.of(), ErrorHandlers.defaultErrorHandler());
    }

    private void checkCredential(Credential credential, String property) {
        Preconditions.checkState(credential.config().containsKey(property), "Invalid ADLS Credentials: %s not set", (Object)property);
    }

    @Override
    public void close() {
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(this.authSession);
        closeableGroup.addCloseable(this.authManager);
        closeableGroup.addCloseable(this.client);
        closeableGroup.setSuppressCloseFailure(true);
        try {
            closeableGroup.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close the VendedAdlsCredentialProvider", e);
        }
    }
}

