/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.azure.adlsv2.VendedAdlsCredentialProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import reactor.core.publisher.Mono;

public class AzureProperties
implements Serializable {
    public static final String ADLS_SAS_TOKEN_PREFIX = "adls.sas-token.";
    public static final String ADLS_SAS_TOKEN_EXPIRES_AT_MS_PREFIX = "adls.sas-token-expires-at-ms.";
    public static final String ADLS_CONNECTION_STRING_PREFIX = "adls.connection-string.";
    public static final String ADLS_READ_BLOCK_SIZE = "adls.read.block-size-bytes";
    public static final String ADLS_WRITE_BLOCK_SIZE = "adls.write.block-size-bytes";
    public static final String ADLS_SHARED_KEY_ACCOUNT_NAME = "adls.auth.shared-key.account.name";
    public static final String ADLS_SHARED_KEY_ACCOUNT_KEY = "adls.auth.shared-key.account.key";
    public static final String ADLS_TOKEN = "adls.token";
    public static final String ADLS_REFRESH_CREDENTIALS_ENDPOINT = "adls.refresh-credentials-endpoint";
    public static final String ADLS_REFRESH_CREDENTIALS_ENABLED = "adls.refresh-credentials-enabled";
    private Map<String, String> adlsSasTokens = Collections.emptyMap();
    private Map<String, String> adlsConnectionStrings = Collections.emptyMap();
    private Map.Entry<String, String> namedKeyCreds;
    private Integer adlsReadBlockSize;
    private Long adlsWriteBlockSize;
    private String adlsRefreshCredentialsEndpoint;
    private boolean adlsRefreshCredentialsEnabled;
    private String token;
    private Map<String, String> allProperties;

    public AzureProperties() {
    }

    public AzureProperties(Map<String, String> properties) {
        this.adlsSasTokens = PropertyUtil.propertiesWithPrefix(properties, ADLS_SAS_TOKEN_PREFIX);
        this.adlsConnectionStrings = PropertyUtil.propertiesWithPrefix(properties, ADLS_CONNECTION_STRING_PREFIX);
        String sharedKeyAccountName = properties.get(ADLS_SHARED_KEY_ACCOUNT_NAME);
        String sharedKeyAccountKey = properties.get(ADLS_SHARED_KEY_ACCOUNT_KEY);
        if (sharedKeyAccountName != null || sharedKeyAccountKey != null) {
            Preconditions.checkArgument(sharedKeyAccountName != null && sharedKeyAccountKey != null, "Azure authentication: shared-key requires both %s and %s", (Object)ADLS_SHARED_KEY_ACCOUNT_NAME, (Object)ADLS_SHARED_KEY_ACCOUNT_KEY);
            this.namedKeyCreds = Maps.immutableEntry(sharedKeyAccountName, sharedKeyAccountKey);
        }
        if (properties.containsKey(ADLS_READ_BLOCK_SIZE)) {
            this.adlsReadBlockSize = Integer.parseInt(properties.get(ADLS_READ_BLOCK_SIZE));
        }
        if (properties.containsKey(ADLS_WRITE_BLOCK_SIZE)) {
            this.adlsWriteBlockSize = Long.parseLong(properties.get(ADLS_WRITE_BLOCK_SIZE));
        }
        this.adlsRefreshCredentialsEndpoint = RESTUtil.resolveEndpoint(properties.get("uri"), properties.get(ADLS_REFRESH_CREDENTIALS_ENDPOINT));
        this.adlsRefreshCredentialsEnabled = PropertyUtil.propertyAsBoolean(properties, ADLS_REFRESH_CREDENTIALS_ENABLED, true);
        this.token = properties.get(ADLS_TOKEN);
        this.allProperties = SerializableMap.copyOf(properties);
    }

    public Optional<Integer> adlsReadBlockSize() {
        return Optional.ofNullable(this.adlsReadBlockSize);
    }

    public Optional<Long> adlsWriteBlockSize() {
        return Optional.ofNullable(this.adlsWriteBlockSize);
    }

    public Optional<VendedAdlsCredentialProvider> vendedAdlsCredentialProvider() {
        if (this.adlsRefreshCredentialsEnabled && !Strings.isNullOrEmpty(this.adlsRefreshCredentialsEndpoint)) {
            HashMap<String, String> credentialProviderProperties = Maps.newHashMap(this.allProperties);
            credentialProviderProperties.put("credentials.uri", this.adlsRefreshCredentialsEndpoint);
            return Optional.of(new VendedAdlsCredentialProvider(credentialProviderProperties));
        }
        return Optional.empty();
    }

    public void applyClientConfiguration(String account, DataLakeFileSystemClientBuilder builder) {
        String connectionString;
        if (!this.adlsRefreshCredentialsEnabled || Strings.isNullOrEmpty(this.adlsRefreshCredentialsEndpoint)) {
            String sasToken = this.adlsSasTokens.get(account);
            if (sasToken != null && !sasToken.isEmpty()) {
                builder.sasToken(sasToken);
            } else if (this.namedKeyCreds != null) {
                builder.credential(new StorageSharedKeyCredential(this.namedKeyCreds.getKey(), this.namedKeyCreds.getValue()));
            } else if (this.token != null && !this.token.isEmpty()) {
                TokenCredential tokenCredential = new TokenCredential(){

                    public Mono<AccessToken> getToken(TokenRequestContext request) {
                        return Mono.just((Object)new AccessToken(AzureProperties.this.token, OffsetDateTime.now(ZoneOffset.UTC).plusHours(1L)));
                    }
                };
                builder.credential(tokenCredential);
            } else {
                builder.credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
            }
        }
        if ((connectionString = this.adlsConnectionStrings.get(account)) != null && !connectionString.isEmpty()) {
            builder.endpoint(connectionString);
        } else {
            builder.endpoint("https://" + account);
        }
    }
}

