/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import java.io.IOException;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignRequest;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignResponse;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.apache.iceberg.aws.s3.signer.S3SignRequestParser;
import org.apache.iceberg.aws.s3.signer.S3SignResponse;
import org.apache.iceberg.aws.s3.signer.S3SignResponseParser;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.PropertyAccessor;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class S3ObjectMapper {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static volatile boolean isInitialized = false;

    private S3ObjectMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ObjectMapper mapper() {
        if (isInitialized) return MAPPER;
        Class<S3ObjectMapper> clazz = S3ObjectMapper.class;
        synchronized (S3ObjectMapper.class) {
            if (isInitialized) return MAPPER;
            MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MAPPER.setPropertyNamingStrategy(new PropertyNamingStrategies.KebabCaseStrategy());
            MAPPER.registerModule(S3ObjectMapper.initModule());
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return MAPPER;
        }
    }

    public static SimpleModule initModule() {
        return new SimpleModule().addSerializer(ErrorResponse.class, new RESTSerializers.ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, new RESTSerializers.ErrorResponseDeserializer()).addSerializer(OAuthTokenResponse.class, new RESTSerializers.OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, new RESTSerializers.OAuthTokenResponseDeserializer()).addSerializer(S3SignRequest.class, new S3SignRequestSerializer()).addSerializer(ImmutableS3SignRequest.class, new S3SignRequestSerializer()).addDeserializer(S3SignRequest.class, new S3SignRequestDeserializer()).addDeserializer(ImmutableS3SignRequest.class, new S3SignRequestDeserializer()).addSerializer(S3SignResponse.class, new S3SignResponseSerializer()).addSerializer(ImmutableS3SignResponse.class, new S3SignResponseSerializer()).addDeserializer(S3SignResponse.class, new S3SignResponseDeserializer()).addDeserializer(ImmutableS3SignResponse.class, new S3SignResponseDeserializer());
    }

    public static class S3SignRequestSerializer<T extends S3SignRequest>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            S3SignRequestParser.toJson(request, gen);
        }
    }

    public static class S3SignRequestDeserializer<T extends S3SignRequest>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)S3SignRequestParser.fromJson(jsonNode);
        }
    }

    public static class S3SignResponseSerializer<T extends S3SignResponse>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            S3SignResponseParser.toJson(request, gen);
        }
    }

    public static class S3SignResponseDeserializer<T extends S3SignResponse>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)S3SignResponseParser.fromJson(jsonNode);
        }
    }
}

