/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.dynamodb;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetastoreOperations;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.dynamodb.DynamoDbCatalog;
import org.apache.iceberg.aws.util.RetryDetector;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

class DynamoDbTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDbTableOperations.class);
    private final DynamoDbClient dynamo;
    private final AwsProperties awsProperties;
    private final TableIdentifier tableIdentifier;
    private final String fullTableName;
    private final FileIO fileIO;

    DynamoDbTableOperations(DynamoDbClient dynamo, AwsProperties awsProperties, String catalogName, FileIO fileIO, TableIdentifier tableIdentifier) {
        this.dynamo = dynamo;
        this.awsProperties = awsProperties;
        this.fullTableName = String.format("%s.%s", catalogName, tableIdentifier);
        this.tableIdentifier = tableIdentifier;
        this.fileIO = fileIO;
    }

    @Override
    protected String tableName() {
        return this.fullTableName;
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    @Override
    protected void doRefresh() {
        String metadataLocation = null;
        GetItemResponse table = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(DynamoDbCatalog.tablePrimaryKey(this.tableIdentifier)).build());
        if (table.hasItem()) {
            metadataLocation = this.getMetadataLocation(table);
        } else if (this.currentMetadataLocation() != null) {
            throw new NoSuchTableException("Cannot find table %s after refresh, maybe another process deleted it or revoked your access permission", this.tableName());
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        boolean newTable = base == null;
        String newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        BaseMetastoreOperations.CommitStatus commitStatus = BaseMetastoreOperations.CommitStatus.FAILURE;
        RetryDetector retryDetector = new RetryDetector();
        Map<String, AttributeValue> tableKey = DynamoDbCatalog.tablePrimaryKey(this.tableIdentifier);
        try {
            GetItemResponse table = this.dynamo.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.awsProperties.dynamoDbTableName()).consistentRead(Boolean.valueOf(true)).key(tableKey).build());
            this.checkMetadataLocation(table, base);
            Map<String, String> properties = this.prepareProperties(table, newMetadataLocation);
            this.persistTable(tableKey, table, properties, retryDetector);
            commitStatus = BaseMetastoreOperations.CommitStatus.SUCCESS;
            return;
        }
        catch (CommitFailedException e) {
            throw e;
        }
        catch (RuntimeException persistFailure) {
            boolean conditionCheckFailed = persistFailure instanceof ConditionalCheckFailedException;
            if (!conditionCheckFailed || retryDetector.retried()) {
                LOG.warn("Received unexpected failure when committing to {}, validating if commit ended up succeeding.", (Object)this.fullTableName, (Object)persistFailure);
                commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
            }
            if (commitStatus != BaseMetastoreOperations.CommitStatus.SUCCESS && conditionCheckFailed) {
                throw new CommitFailedException(persistFailure, "Cannot commit %s: concurrent update detected", this.tableName());
            }
            switch (commitStatus) {
                case SUCCESS: {
                    return;
                }
                case FAILURE: {
                    throw new CommitFailedException(persistFailure, "Cannot commit %s due to unexpected exception", this.tableName());
                }
                case UNKNOWN: {
                    throw new CommitStateUnknownException(persistFailure);
                }
            }
            return;
        }
        finally {
            try {
                if (commitStatus == BaseMetastoreOperations.CommitStatus.FAILURE) {
                    this.io().deleteFile(newMetadataLocation);
                }
            }
            catch (RuntimeException e) {
                LOG.error("Failed to cleanup metadata file at {}", (Object)newMetadataLocation, (Object)e);
            }
        }
    }

    private void checkMetadataLocation(GetItemResponse table, TableMetadata base) {
        String baseMetadataLocation;
        String dynamoMetadataLocation = table.hasItem() ? this.getMetadataLocation(table) : null;
        String string = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
        if (!Objects.equals(baseMetadataLocation, dynamoMetadataLocation)) {
            throw new CommitFailedException("Cannot commit %s because base metadata location '%s' is not same as the current DynamoDb location '%s'", this.tableName(), baseMetadataLocation, dynamoMetadataLocation);
        }
    }

    private String getMetadataLocation(GetItemResponse table) {
        return ((AttributeValue)table.item().get(DynamoDbCatalog.toPropertyCol("metadata_location"))).s();
    }

    private Map<String, String> prepareProperties(GetItemResponse response, String newMetadataLocation) {
        HashMap<String, String> properties = response.hasItem() ? this.getProperties(response) : Maps.newHashMap();
        properties.put("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        properties.put("metadata_location", newMetadataLocation);
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            properties.put("previous_metadata_location", this.currentMetadataLocation());
        }
        return properties;
    }

    private Map<String, String> getProperties(GetItemResponse table) {
        return table.item().entrySet().stream().filter(e -> DynamoDbCatalog.isProperty((String)e.getKey())).collect(Collectors.toMap(e -> DynamoDbCatalog.toPropertyKey((String)e.getKey()), e -> ((AttributeValue)e.getValue()).s()));
    }

    void persistTable(Map<String, AttributeValue> tableKey, GetItemResponse table, Map<String, String> parameters, RetryDetector retryDetector) {
        if (table.hasItem()) {
            LOG.debug("Committing existing DynamoDb catalog table: {}", (Object)this.tableName());
            ArrayList<String> updateParts = Lists.newArrayList();
            HashMap<CallSite, String> attributeNames = Maps.newHashMap();
            HashMap<String, AttributeValue> attributeValues = Maps.newHashMap();
            int idx = 0;
            for (Map.Entry<String, String> property : parameters.entrySet()) {
                String attributeValue = ":v" + idx;
                String attributeKey = "#k" + idx;
                ++idx;
                updateParts.add(attributeKey + " = " + attributeValue);
                attributeNames.put((CallSite)((Object)attributeKey), DynamoDbCatalog.toPropertyCol(property.getKey()));
                attributeValues.put(attributeValue, (AttributeValue)AttributeValue.builder().s(property.getValue()).build());
            }
            DynamoDbCatalog.updateCatalogEntryMetadata(updateParts, attributeValues);
            String updateExpression = "SET " + DynamoDbCatalog.COMMA.join(updateParts);
            attributeValues.put(":v", (AttributeValue)table.item().get("v"));
            this.dynamo.updateItem((UpdateItemRequest)UpdateItemRequest.builder().overrideConfiguration(c -> c.addMetricPublisher((MetricPublisher)retryDetector)).tableName(this.awsProperties.dynamoDbTableName()).key(tableKey).conditionExpression("v = :v").updateExpression(updateExpression).expressionAttributeValues(attributeValues).expressionAttributeNames(attributeNames).build());
        } else {
            LOG.debug("Committing new DynamoDb catalog table: {}", (Object)this.tableName());
            HashMap<String, AttributeValue> values = Maps.newHashMap(tableKey);
            parameters.forEach((k, v) -> values.put(DynamoDbCatalog.toPropertyCol(k), (AttributeValue)AttributeValue.builder().s(v).build()));
            DynamoDbCatalog.setNewCatalogEntryMetadata(values);
            this.dynamo.putItem((PutItemRequest)PutItemRequest.builder().overrideConfiguration(c -> c.addMetricPublisher((MetricPublisher)retryDetector)).tableName(this.awsProperties.dynamoDbTableName()).item(values).conditionExpression("attribute_not_exists(v)").build());
        }
    }
}

