/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.s3.S3FileIOAwsClientFactory;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.util.PropertyUtil;

public class S3FileIOAwsClientFactories {
    private S3FileIOAwsClientFactories() {
    }

    public static <T> T initialize(Map<String, String> properties) {
        String factoryImpl = PropertyUtil.propertyAsString(properties, "s3.client-factory-impl", null);
        if (Strings.isNullOrEmpty(factoryImpl)) {
            return (T)AwsClientFactories.from(properties);
        }
        return (T)S3FileIOAwsClientFactories.loadClientFactory(factoryImpl, properties);
    }

    private static S3FileIOAwsClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        S3FileIOAwsClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(S3FileIOAwsClientFactory.class).loader(S3FileIOAwsClientFactories.class.getClassLoader()).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize S3FileIOAwsClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (S3FileIOAwsClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize S3FileIOAwsClientFactory, %s does not implement S3FileIOAwsClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }
}

