/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.sts.model.Tag;

public class AwsProperties
implements Serializable {
    public static final String GLUE_CATALOG_ID = "glue.id";
    public static final String GLUE_ACCOUNT_ID = "glue.account-id";
    public static final String GLUE_CATALOG_SKIP_ARCHIVE = "glue.skip-archive";
    public static final boolean GLUE_CATALOG_SKIP_ARCHIVE_DEFAULT = true;
    public static final String GLUE_CATALOG_SKIP_NAME_VALIDATION = "glue.skip-name-validation";
    public static final boolean GLUE_CATALOG_SKIP_NAME_VALIDATION_DEFAULT = false;
    public static final String GLUE_LAKEFORMATION_ENABLED = "glue.lakeformation-enabled";
    public static final boolean GLUE_LAKEFORMATION_ENABLED_DEFAULT = false;
    public static final String GLUE_CATALOG_ENDPOINT = "glue.endpoint";
    public static final String DYNAMODB_ENDPOINT = "dynamodb.endpoint";
    public static final String DYNAMODB_TABLE_NAME = "dynamodb.table-name";
    public static final String DYNAMODB_TABLE_NAME_DEFAULT = "iceberg";
    public static final String CLIENT_FACTORY = "client.factory";
    public static final String CLIENT_ASSUME_ROLE_ARN = "client.assume-role.arn";
    public static final String CLIENT_ASSUME_ROLE_TAGS_PREFIX = "client.assume-role.tags.";
    public static final String CLIENT_ASSUME_ROLE_TIMEOUT_SEC = "client.assume-role.timeout-sec";
    public static final int CLIENT_ASSUME_ROLE_TIMEOUT_SEC_DEFAULT = 3600;
    public static final String CLIENT_ASSUME_ROLE_EXTERNAL_ID = "client.assume-role.external-id";
    public static final String CLIENT_ASSUME_ROLE_REGION = "client.assume-role.region";
    public static final String CLIENT_ASSUME_ROLE_SESSION_NAME = "client.assume-role.session-name";
    public static final String LAKE_FORMATION_TABLE_NAME = "lakeformation.table-name";
    public static final String LAKE_FORMATION_DB_NAME = "lakeformation.db-name";
    public static final String REST_SIGNER_REGION = "rest.signing-region";
    public static final String REST_SIGNING_NAME = "rest.signing-name";
    public static final String REST_SIGNING_NAME_DEFAULT = "execute-api";
    public static final String REST_ACCESS_KEY_ID = "rest.access-key-id";
    public static final String REST_SECRET_ACCESS_KEY = "rest.secret-access-key";
    public static final String REST_SESSION_TOKEN = "rest.session-token";
    public static final String KMS_ENCRYPTION_ALGORITHM_SPEC = "kms.encryption-algorithm-spec";
    public static final EncryptionAlgorithmSpec KMS_ENCRYPTION_ALGORITHM_SPEC_DEFAULT = EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT;
    public static final String KMS_DATA_KEY_SPEC = "kms.data-key-spec";
    public static final DataKeySpec KMS_DATA_KEY_SPEC_DEFAULT = DataKeySpec.AES_256;
    private final Set<Tag> stsClientAssumeRoleTags;
    private final String clientAssumeRoleArn;
    private final String clientAssumeRoleExternalId;
    private final int clientAssumeRoleTimeoutSec;
    private final String clientAssumeRoleRegion;
    private final String clientAssumeRoleSessionName;
    private final String clientCredentialsProvider;
    private final Map<String, String> clientCredentialsProviderProperties;
    private final String glueEndpoint;
    private String glueCatalogId;
    private boolean glueCatalogSkipArchive;
    private boolean glueCatalogSkipNameValidation;
    private boolean glueLakeFormationEnabled;
    private String dynamoDbTableName;
    private final String dynamoDbEndpoint;
    private String restSigningRegion;
    private final String restSigningName;
    private String restAccessKeyId;
    private String restSecretAccessKey;
    private String restSessionToken;
    private EncryptionAlgorithmSpec kmsEncryptionAlgorithmSpec;
    private DataKeySpec kmsDataKeySpec;

    public AwsProperties() {
        this.stsClientAssumeRoleTags = Sets.newHashSet();
        this.clientAssumeRoleArn = null;
        this.clientAssumeRoleTimeoutSec = 3600;
        this.clientAssumeRoleExternalId = null;
        this.clientAssumeRoleRegion = null;
        this.clientAssumeRoleSessionName = null;
        this.clientCredentialsProvider = null;
        this.clientCredentialsProviderProperties = null;
        this.glueCatalogId = null;
        this.glueEndpoint = null;
        this.glueCatalogSkipArchive = true;
        this.glueCatalogSkipNameValidation = false;
        this.glueLakeFormationEnabled = false;
        this.dynamoDbEndpoint = null;
        this.dynamoDbTableName = DYNAMODB_TABLE_NAME_DEFAULT;
        this.restSigningName = REST_SIGNING_NAME_DEFAULT;
        this.kmsEncryptionAlgorithmSpec = KMS_ENCRYPTION_ALGORITHM_SPEC_DEFAULT;
        this.kmsDataKeySpec = KMS_DATA_KEY_SPEC_DEFAULT;
    }

    public AwsProperties(Map<String, String> properties) {
        this.stsClientAssumeRoleTags = this.toStsTags(properties, CLIENT_ASSUME_ROLE_TAGS_PREFIX);
        this.clientAssumeRoleArn = properties.get(CLIENT_ASSUME_ROLE_ARN);
        this.clientAssumeRoleTimeoutSec = PropertyUtil.propertyAsInt(properties, CLIENT_ASSUME_ROLE_TIMEOUT_SEC, 3600);
        this.clientAssumeRoleExternalId = properties.get(CLIENT_ASSUME_ROLE_EXTERNAL_ID);
        this.clientAssumeRoleRegion = properties.get(CLIENT_ASSUME_ROLE_REGION);
        this.clientAssumeRoleSessionName = properties.get(CLIENT_ASSUME_ROLE_SESSION_NAME);
        this.clientCredentialsProvider = properties.get("client.credentials-provider");
        this.clientCredentialsProviderProperties = PropertyUtil.propertiesWithPrefix(properties, "client.credentials-provider.");
        this.glueEndpoint = properties.get(GLUE_CATALOG_ENDPOINT);
        this.glueCatalogId = properties.get(GLUE_CATALOG_ID);
        this.glueCatalogSkipArchive = PropertyUtil.propertyAsBoolean(properties, GLUE_CATALOG_SKIP_ARCHIVE, true);
        this.glueCatalogSkipNameValidation = PropertyUtil.propertyAsBoolean(properties, GLUE_CATALOG_SKIP_NAME_VALIDATION, false);
        this.glueLakeFormationEnabled = PropertyUtil.propertyAsBoolean(properties, GLUE_LAKEFORMATION_ENABLED, false);
        this.dynamoDbEndpoint = properties.get(DYNAMODB_ENDPOINT);
        this.dynamoDbTableName = PropertyUtil.propertyAsString(properties, DYNAMODB_TABLE_NAME, DYNAMODB_TABLE_NAME_DEFAULT);
        this.restSigningRegion = properties.get(REST_SIGNER_REGION);
        this.restSigningName = properties.getOrDefault(REST_SIGNING_NAME, REST_SIGNING_NAME_DEFAULT);
        this.restAccessKeyId = properties.get(REST_ACCESS_KEY_ID);
        this.restSecretAccessKey = properties.get(REST_SECRET_ACCESS_KEY);
        this.restSessionToken = properties.get(REST_SESSION_TOKEN);
        this.kmsEncryptionAlgorithmSpec = EncryptionAlgorithmSpec.fromValue((String)properties.getOrDefault(KMS_ENCRYPTION_ALGORITHM_SPEC, KMS_ENCRYPTION_ALGORITHM_SPEC_DEFAULT.toString()));
        this.kmsDataKeySpec = DataKeySpec.fromValue((String)properties.getOrDefault(KMS_DATA_KEY_SPEC, KMS_DATA_KEY_SPEC_DEFAULT.toString()));
    }

    public Set<Tag> stsClientAssumeRoleTags() {
        return this.stsClientAssumeRoleTags;
    }

    public String clientAssumeRoleArn() {
        return this.clientAssumeRoleArn;
    }

    public int clientAssumeRoleTimeoutSec() {
        return this.clientAssumeRoleTimeoutSec;
    }

    public String clientAssumeRoleExternalId() {
        return this.clientAssumeRoleExternalId;
    }

    public String clientAssumeRoleRegion() {
        return this.clientAssumeRoleRegion;
    }

    public String clientAssumeRoleSessionName() {
        return this.clientAssumeRoleSessionName;
    }

    public String glueCatalogId() {
        return this.glueCatalogId;
    }

    public void setGlueCatalogId(String id) {
        this.glueCatalogId = id;
    }

    public boolean glueCatalogSkipArchive() {
        return this.glueCatalogSkipArchive;
    }

    public void setGlueCatalogSkipArchive(boolean skipArchive) {
        this.glueCatalogSkipArchive = skipArchive;
    }

    public boolean glueCatalogSkipNameValidation() {
        return this.glueCatalogSkipNameValidation;
    }

    public void setGlueCatalogSkipNameValidation(boolean glueCatalogSkipNameValidation) {
        this.glueCatalogSkipNameValidation = glueCatalogSkipNameValidation;
    }

    public boolean glueLakeFormationEnabled() {
        return this.glueLakeFormationEnabled;
    }

    public void setGlueLakeFormationEnabled(boolean glueLakeFormationEnabled) {
        this.glueLakeFormationEnabled = glueLakeFormationEnabled;
    }

    public String dynamoDbTableName() {
        return this.dynamoDbTableName;
    }

    public void setDynamoDbTableName(String name) {
        this.dynamoDbTableName = name;
    }

    public <T extends GlueClientBuilder> void applyGlueEndpointConfigurations(T builder) {
        this.configureEndpoint(builder, this.glueEndpoint);
    }

    public <T extends DynamoDbClientBuilder> void applyDynamoDbEndpointConfigurations(T builder) {
        this.configureEndpoint(builder, this.dynamoDbEndpoint);
    }

    public Region restSigningRegion() {
        if (this.restSigningRegion == null) {
            this.restSigningRegion = DefaultAwsRegionProviderChain.builder().build().getRegion().id();
        }
        return Region.of((String)this.restSigningRegion);
    }

    public String restSigningName() {
        return this.restSigningName;
    }

    public AwsCredentialsProvider restCredentialsProvider() {
        return this.credentialsProvider(this.restAccessKeyId, this.restSecretAccessKey, this.restSessionToken);
    }

    public EncryptionAlgorithmSpec kmsEncryptionAlgorithmSpec() {
        return this.kmsEncryptionAlgorithmSpec;
    }

    public DataKeySpec kmsDataKeySpec() {
        return this.kmsDataKeySpec;
    }

    private Set<Tag> toStsTags(Map<String, String> properties, String prefix) {
        return PropertyUtil.propertiesWithPrefix(properties, prefix).entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }

    private AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (accessKeyId != null) {
            if (sessionToken == null) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            return this.credentialsProvider(this.clientCredentialsProvider);
        }
        return DefaultCredentialsProvider.builder().build();
    }

    private AwsCredentialsProvider credentialsProvider(String credentialsProviderClass) {
        Class providerClass;
        try {
            providerClass = DynClasses.builder().impl(credentialsProviderClass).buildChecked();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot load class %s, it does not exist in the classpath", credentialsProviderClass), e);
        }
        Preconditions.checkArgument(AwsCredentialsProvider.class.isAssignableFrom(providerClass), String.format("Cannot initialize %s, it does not implement %s.", credentialsProviderClass, AwsCredentialsProvider.class.getName()));
        try {
            AwsCredentialsProvider provider;
            try {
                provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, Map.class).buildStaticChecked().invoke(this.clientCredentialsProviderProperties);
            }
            catch (NoSuchMethodException e) {
                provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, new Class[0]).buildStaticChecked().invoke(new Object[0]);
            }
            return provider;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of %s, it does not contain a static 'create' or 'create(Map<String, String>)' method", credentialsProviderClass), e);
        }
    }

    private <T extends SdkClientBuilder> void configureEndpoint(T builder, String endpoint) {
        if (endpoint != null) {
            builder.endpointOverride(URI.create(endpoint));
        }
    }
}

