/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsClientProperties;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.HttpClientProperties;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleAwsClientFactory
implements AwsClientFactory {
    private AwsProperties awsProperties;
    private HttpClientProperties httpClientProperties;
    private S3FileIOProperties s3FileIOProperties;
    private String roleSessionName;
    private AwsClientProperties awsClientProperties;

    @Override
    public S3Client s3() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.awsClientProperties::applyLegacyMd5Plugin)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyServiceConfigurations)).applyMutation(this.s3FileIOProperties::applySignerConfiguration)).applyMutation(this.s3FileIOProperties::applyRetryConfigurations)).build();
    }

    @Override
    public S3AsyncClient s3Async() {
        if (this.s3FileIOProperties.isS3CRTEnabled()) {
            return ((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)((S3CrtAsyncClientBuilder)S3AsyncClient.crtBuilder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.awsClientProperties::applyClientCredentialConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyS3CrtConfigurations)).build();
        }
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.awsClientProperties::applyClientCredentialConfigurations)).applyMutation(this.awsClientProperties::applyLegacyMd5Plugin)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).build();
    }

    @Override
    public GlueClient glue() {
        return (GlueClient)((GlueClientBuilder)((GlueClientBuilder)GlueClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).build();
    }

    @Override
    public KmsClient kms() {
        return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsClientProperties::applyRetryConfigurations)).build();
    }

    @Override
    public DynamoDbClient dynamo() {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsProperties::applyDynamoDbEndpointConfigurations)).build();
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.awsProperties = new AwsProperties(properties);
        this.s3FileIOProperties = new S3FileIOProperties(properties);
        this.httpClientProperties = new HttpClientProperties(properties);
        this.awsClientProperties = new AwsClientProperties(properties);
        this.roleSessionName = this.genSessionName();
        Preconditions.checkNotNull(this.awsProperties.clientAssumeRoleArn(), "Cannot initialize AssumeRoleClientConfigFactory with null role ARN");
        Preconditions.checkNotNull(this.awsProperties.clientAssumeRoleRegion(), "Cannot initialize AssumeRoleClientConfigFactory with null region");
    }

    protected <T extends AwsClientBuilder & AwsSyncClientBuilder> T applyAssumeRoleConfigurations(T clientBuilder) {
        clientBuilder.credentialsProvider((AwsCredentialsProvider)this.createCredentialsProvider()).region(Region.of((String)this.awsProperties.clientAssumeRoleRegion()));
        return clientBuilder;
    }

    protected S3AsyncClientBuilder applyAssumeRoleConfigurations(S3AsyncClientBuilder clientBuilder) {
        return (S3AsyncClientBuilder)((S3AsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)this.createCredentialsProvider())).region(Region.of((String)this.awsProperties.clientAssumeRoleRegion()));
    }

    protected S3CrtAsyncClientBuilder applyAssumeRoleConfigurations(S3CrtAsyncClientBuilder clientBuilder) {
        return clientBuilder.credentialsProvider((AwsCredentialsProvider)this.createCredentialsProvider()).region(Region.of((String)this.awsProperties.clientAssumeRoleRegion()));
    }

    protected String region() {
        return this.awsProperties.clientAssumeRoleRegion();
    }

    protected AwsProperties awsProperties() {
        return this.awsProperties;
    }

    protected HttpClientProperties httpClientProperties() {
        return this.httpClientProperties;
    }

    protected S3FileIOProperties s3FileIOProperties() {
        return this.s3FileIOProperties;
    }

    protected AwsClientProperties awsClientProperties() {
        return this.awsClientProperties;
    }

    private StsClient sts() {
        return (StsClient)((StsClientBuilder)StsClient.builder().applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).build();
    }

    private String genSessionName() {
        if (this.awsProperties.clientAssumeRoleSessionName() != null) {
            return this.awsProperties.clientAssumeRoleSessionName();
        }
        return String.format("iceberg-aws-%s", UUID.randomUUID());
    }

    private StsAssumeRoleCredentialsProvider createCredentialsProvider() {
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(this.sts())).refreshRequest(this.createAssumeRoleRequest()).build();
    }

    private AssumeRoleRequest createAssumeRoleRequest() {
        return (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.awsProperties.clientAssumeRoleArn()).roleSessionName(this.roleSessionName).durationSeconds(Integer.valueOf(this.awsProperties.clientAssumeRoleTimeoutSec())).externalId(this.awsProperties.clientAssumeRoleExternalId()).tags(this.awsProperties.stsClientAssumeRoleTags()).build();
    }
}

