/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteTablePathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RewriteTablePathUtil.class);
    public static final String FILE_SEPARATOR = "/";

    private RewriteTablePathUtil() {
    }

    public static TableMetadata replacePaths(TableMetadata metadata, String sourcePrefix, String targetPrefix) {
        String newLocation = metadata.location().replaceFirst(sourcePrefix, targetPrefix);
        List<Snapshot> newSnapshots = RewriteTablePathUtil.updatePathInSnapshots(metadata, sourcePrefix, targetPrefix);
        List<TableMetadata.MetadataLogEntry> metadataLogEntries = RewriteTablePathUtil.updatePathInMetadataLogs(metadata, sourcePrefix, targetPrefix);
        long snapshotId = metadata.currentSnapshot() == null ? -1L : metadata.currentSnapshot().snapshotId();
        Map<String, String> properties = RewriteTablePathUtil.updateProperties(metadata.properties(), sourcePrefix, targetPrefix);
        return new TableMetadata(null, metadata.formatVersion(), metadata.uuid(), newLocation, metadata.lastSequenceNumber(), metadata.lastUpdatedMillis(), metadata.lastColumnId(), metadata.currentSchemaId(), metadata.schemas(), metadata.defaultSpecId(), metadata.specs(), metadata.lastAssignedPartitionId(), metadata.defaultSortOrderId(), metadata.sortOrders(), properties, snapshotId, newSnapshots, null, metadata.snapshotLog(), metadataLogEntries, metadata.refs(), RewriteTablePathUtil.updatePathInStatisticsFiles(metadata.statisticsFiles(), sourcePrefix, targetPrefix), metadata.partitionStatisticsFiles(), metadata.nextRowId(), metadata.encryptionKeys(), metadata.changes());
    }

    private static Map<String, String> updateProperties(Map<String, String> tableProperties, String sourcePrefix, String targetPrefix) {
        HashMap<String, String> properties = Maps.newHashMap(tableProperties);
        RewriteTablePathUtil.updatePathInProperty(properties, sourcePrefix, targetPrefix, "write.object-storage.path");
        RewriteTablePathUtil.updatePathInProperty(properties, sourcePrefix, targetPrefix, "write.folder-storage.path");
        RewriteTablePathUtil.updatePathInProperty(properties, sourcePrefix, targetPrefix, "write.data.path");
        RewriteTablePathUtil.updatePathInProperty(properties, sourcePrefix, targetPrefix, "write.metadata.path");
        return properties;
    }

    private static void updatePathInProperty(Map<String, String> properties, String sourcePrefix, String targetPrefix, String propertyName) {
        if (properties.containsKey(propertyName)) {
            properties.put(propertyName, RewriteTablePathUtil.newPath(properties.get(propertyName), sourcePrefix, targetPrefix));
        }
    }

    private static List<StatisticsFile> updatePathInStatisticsFiles(List<StatisticsFile> statisticsFiles, String sourcePrefix, String targetPrefix) {
        return statisticsFiles.stream().map(existing -> new GenericStatisticsFile(existing.snapshotId(), RewriteTablePathUtil.newPath(existing.path(), sourcePrefix, targetPrefix), existing.fileSizeInBytes(), existing.fileFooterSizeInBytes(), existing.blobMetadata())).collect(Collectors.toList());
    }

    private static List<TableMetadata.MetadataLogEntry> updatePathInMetadataLogs(TableMetadata metadata, String sourcePrefix, String targetPrefix) {
        ArrayList<TableMetadata.MetadataLogEntry> metadataLogEntries = Lists.newArrayListWithCapacity(metadata.previousFiles().size());
        for (TableMetadata.MetadataLogEntry metadataLog : metadata.previousFiles()) {
            TableMetadata.MetadataLogEntry newMetadataLog = new TableMetadata.MetadataLogEntry(metadataLog.timestampMillis(), RewriteTablePathUtil.newPath(metadataLog.file(), sourcePrefix, targetPrefix));
            metadataLogEntries.add(newMetadataLog);
        }
        return metadataLogEntries;
    }

    private static List<Snapshot> updatePathInSnapshots(TableMetadata metadata, String sourcePrefix, String targetPrefix) {
        ArrayList<Snapshot> newSnapshots = Lists.newArrayListWithCapacity(metadata.snapshots().size());
        for (Snapshot snapshot : metadata.snapshots()) {
            String newManifestListLocation = RewriteTablePathUtil.newPath(snapshot.manifestListLocation(), sourcePrefix, targetPrefix);
            BaseSnapshot newSnapshot = new BaseSnapshot(snapshot.sequenceNumber(), snapshot.snapshotId(), snapshot.parentId(), snapshot.timestampMillis(), snapshot.operation(), snapshot.summary(), snapshot.schemaId(), newManifestListLocation, snapshot.firstRowId(), snapshot.addedRows(), snapshot.keyId());
            newSnapshots.add(newSnapshot);
        }
        return newSnapshots;
    }

    public static RewriteResult<ManifestFile> rewriteManifestList(Snapshot snapshot, FileIO io, TableMetadata tableMetadata, Set<String> manifestsToRewrite, String sourcePrefix, String targetPrefix, String stagingDir, String outputPath) {
        RewriteResult rewriteResult;
        block9: {
            RewriteResult result = new RewriteResult();
            OutputFile outputFile = io.newOutputFile(outputPath);
            List<ManifestFile> manifestFiles = RewriteTablePathUtil.manifestFilesInSnapshot(io, snapshot);
            manifestFiles.forEach(mf -> Preconditions.checkArgument(mf.path().startsWith(sourcePrefix), "Encountered manifest file %s not under the source prefix %s", (Object)mf.path(), (Object)sourcePrefix));
            ManifestListWriter writer = ManifestLists.write(tableMetadata.formatVersion(), outputFile, snapshot.snapshotId(), snapshot.parentId(), snapshot.sequenceNumber(), snapshot.firstRowId());
            try {
                for (ManifestFile file : manifestFiles) {
                    ManifestFile newFile = file.copy();
                    ((StructLike)((Object)newFile)).set(0, RewriteTablePathUtil.newPath(newFile.path(), sourcePrefix, targetPrefix));
                    writer.add(newFile);
                    if (!manifestsToRewrite.contains(file.path())) continue;
                    result.toRewrite().add(file);
                    result.copyPlan().add(Pair.of(RewriteTablePathUtil.stagingPath(file.path(), sourcePrefix, stagingDir), newFile.path()));
                }
                rewriteResult = result;
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to rewrite the manifest list file " + snapshot.manifestListLocation(), e);
                }
            }
            writer.close();
        }
        return rewriteResult;
    }

    private static List<ManifestFile> manifestFilesInSnapshot(FileIO io, Snapshot snapshot) {
        String path = snapshot.manifestListLocation();
        LinkedList<ManifestFile> manifestFiles = Lists.newLinkedList();
        try {
            manifestFiles = ManifestLists.read(io.newInputFile(path));
        }
        catch (RuntimeIOException e) {
            LOG.warn("Failed to read manifest list {}", (Object)path, (Object)e);
        }
        return manifestFiles;
    }

    @Deprecated
    public static RewriteResult<DataFile> rewriteDataManifest(ManifestFile manifestFile, OutputFile outputFile, FileIO io, int format, Map<Integer, PartitionSpec> specsById, String sourcePrefix, String targetPrefix) throws IOException {
        PartitionSpec spec = specsById.get(manifestFile.partitionSpecId());
        try (ManifestWriter<DataFile> writer = ManifestFiles.write(format, spec, outputFile, manifestFile.snapshotId());){
            RewriteResult rewriteResult;
            block12: {
                ManifestReader<DataFile> reader = ManifestFiles.read(manifestFile, io, specsById).select(Arrays.asList("*"));
                try {
                    rewriteResult = StreamSupport.stream(reader.entries().spliterator(), false).map(entry -> RewriteTablePathUtil.writeDataFileEntry(entry, Set.of(), spec, sourcePrefix, targetPrefix, writer)).reduce(new RewriteResult(), RewriteResult::append);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return rewriteResult;
        }
    }

    public static RewriteResult<DataFile> rewriteDataManifest(ManifestFile manifestFile, Set<Long> snapshotIds, OutputFile outputFile, FileIO io, int format, Map<Integer, PartitionSpec> specsById, String sourcePrefix, String targetPrefix) throws IOException {
        PartitionSpec spec = specsById.get(manifestFile.partitionSpecId());
        try (ManifestWriter<DataFile> writer = ManifestFiles.write(format, spec, outputFile, manifestFile.snapshotId());){
            RewriteResult rewriteResult;
            block12: {
                ManifestReader<DataFile> reader = ManifestFiles.read(manifestFile, io, specsById).select(Arrays.asList("*"));
                try {
                    rewriteResult = StreamSupport.stream(reader.entries().spliterator(), false).map(entry -> RewriteTablePathUtil.writeDataFileEntry(entry, snapshotIds, spec, sourcePrefix, targetPrefix, writer)).reduce(new RewriteResult(), RewriteResult::append);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return rewriteResult;
        }
    }

    @Deprecated
    public static RewriteResult<DeleteFile> rewriteDeleteManifest(ManifestFile manifestFile, OutputFile outputFile, FileIO io, int format, Map<Integer, PartitionSpec> specsById, String sourcePrefix, String targetPrefix, String stagingLocation) throws IOException {
        PartitionSpec spec = specsById.get(manifestFile.partitionSpecId());
        try (ManifestWriter<DeleteFile> writer = ManifestFiles.writeDeleteManifest(format, spec, outputFile, manifestFile.snapshotId());){
            RewriteResult rewriteResult;
            block12: {
                ManifestReader<DeleteFile> reader = ManifestFiles.readDeleteManifest(manifestFile, io, specsById).select(Arrays.asList("*"));
                try {
                    rewriteResult = StreamSupport.stream(reader.entries().spliterator(), false).map(entry -> RewriteTablePathUtil.writeDeleteFileEntry(entry, Set.of(), spec, sourcePrefix, targetPrefix, stagingLocation, writer)).reduce(new RewriteResult(), RewriteResult::append);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return rewriteResult;
        }
    }

    public static RewriteResult<DeleteFile> rewriteDeleteManifest(ManifestFile manifestFile, Set<Long> snapshotIds, OutputFile outputFile, FileIO io, int format, Map<Integer, PartitionSpec> specsById, String sourcePrefix, String targetPrefix, String stagingLocation) throws IOException {
        PartitionSpec spec = specsById.get(manifestFile.partitionSpecId());
        try (ManifestWriter<DeleteFile> writer = ManifestFiles.writeDeleteManifest(format, spec, outputFile, manifestFile.snapshotId());){
            RewriteResult rewriteResult;
            block12: {
                ManifestReader<DeleteFile> reader = ManifestFiles.readDeleteManifest(manifestFile, io, specsById).select(Arrays.asList("*"));
                try {
                    rewriteResult = StreamSupport.stream(reader.entries().spliterator(), false).map(entry -> RewriteTablePathUtil.writeDeleteFileEntry(entry, snapshotIds, spec, sourcePrefix, targetPrefix, stagingLocation, writer)).reduce(new RewriteResult(), RewriteResult::append);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return rewriteResult;
        }
    }

    private static RewriteResult<DataFile> writeDataFileEntry(ManifestEntry<DataFile> entry, Set<Long> snapshotIds, PartitionSpec spec, String sourcePrefix, String targetPrefix, ManifestWriter<DataFile> writer) {
        RewriteResult<DataFile> result = new RewriteResult<DataFile>();
        DataFile dataFile = entry.file();
        String sourceDataFilePath = dataFile.location();
        Preconditions.checkArgument(sourceDataFilePath.startsWith(sourcePrefix), "Encountered data file %s not under the source prefix %s", (Object)sourceDataFilePath, (Object)sourcePrefix);
        String targetDataFilePath = RewriteTablePathUtil.newPath(sourceDataFilePath, sourcePrefix, targetPrefix);
        DataFile newDataFile = DataFiles.builder(spec).copy(entry.file()).withPath(targetDataFilePath).build();
        RewriteTablePathUtil.appendEntryWithFile(entry, writer, newDataFile);
        if (entry.isLive() && snapshotIds.contains(entry.snapshotId())) {
            result.copyPlan().add(Pair.of(sourceDataFilePath, newDataFile.location()));
        }
        return result;
    }

    private static RewriteResult<DeleteFile> writeDeleteFileEntry(ManifestEntry<DeleteFile> entry, Set<Long> snapshotIds, PartitionSpec spec, String sourcePrefix, String targetPrefix, String stagingLocation, ManifestWriter<DeleteFile> writer) {
        DeleteFile file = entry.file();
        RewriteResult<DeleteFile> result = new RewriteResult<DeleteFile>();
        switch (file.content()) {
            case POSITION_DELETES: {
                String targetDeleteFilePath = RewriteTablePathUtil.newPath(file.location(), sourcePrefix, targetPrefix);
                Metrics metricsWithTargetPath = ContentFileUtil.replacePathBounds(file, sourcePrefix, targetPrefix);
                DeleteFile movedFile = FileMetadata.deleteFileBuilder(spec).copy(file).withPath(targetDeleteFilePath).withMetrics(metricsWithTargetPath).build();
                RewriteTablePathUtil.appendEntryWithFile(entry, writer, movedFile);
                if (entry.isLive() && snapshotIds.contains(entry.snapshotId())) {
                    result.copyPlan().add(Pair.of(RewriteTablePathUtil.stagingPath(file.location(), sourcePrefix, stagingLocation), movedFile.location()));
                }
                result.toRewrite().add(file);
                return result;
            }
            case EQUALITY_DELETES: {
                DeleteFile eqDeleteFile = RewriteTablePathUtil.newEqualityDeleteEntry(file, spec, sourcePrefix, targetPrefix);
                RewriteTablePathUtil.appendEntryWithFile(entry, writer, eqDeleteFile);
                if (entry.isLive() && snapshotIds.contains(entry.snapshotId())) {
                    result.copyPlan().add(Pair.of(file.location(), eqDeleteFile.location()));
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Unsupported delete file type: " + String.valueOf((Object)file.content()));
    }

    private static <F extends ContentFile<F>> void appendEntryWithFile(ManifestEntry<F> entry, ManifestWriter<F> writer, F file) {
        switch (entry.status()) {
            case ADDED: {
                writer.add(file);
                break;
            }
            case EXISTING: {
                writer.existing(file, entry.snapshotId(), entry.dataSequenceNumber(), entry.fileSequenceNumber());
                break;
            }
            case DELETED: {
                writer.delete(file, entry.dataSequenceNumber(), entry.fileSequenceNumber());
            }
        }
    }

    private static DeleteFile newEqualityDeleteEntry(DeleteFile file, PartitionSpec spec, String sourcePrefix, String targetPrefix) {
        String path = file.location();
        if (!path.startsWith(sourcePrefix)) {
            throw new UnsupportedOperationException("Expected delete file to be under the source prefix: " + sourcePrefix + " but was " + path);
        }
        int[] equalityFieldIds = file.equalityFieldIds().stream().mapToInt(Integer::intValue).toArray();
        String newPath = RewriteTablePathUtil.newPath(path, sourcePrefix, targetPrefix);
        return FileMetadata.deleteFileBuilder(spec).ofEqualityDeletes(equalityFieldIds).copy(file).withPath(newPath).withSplitOffsets(file.splitOffsets()).build();
    }

    public static void rewritePositionDeleteFile(DeleteFile deleteFile, OutputFile outputFile, FileIO io, PartitionSpec spec, String sourcePrefix, String targetPrefix, PositionDeleteReaderWriter posDeleteReaderWriter) throws IOException {
        block15: {
            String path = deleteFile.location();
            if (!path.startsWith(sourcePrefix)) {
                throw new UnsupportedOperationException(String.format("Expected delete file %s to start with prefix: %s", path, sourcePrefix));
            }
            InputFile sourceFile = io.newInputFile(path);
            try (CloseableIterable<Record> reader = posDeleteReaderWriter.reader(sourceFile, deleteFile.format(), spec);){
                Record record = null;
                Schema rowSchema = null;
                Iterator recordIt = reader.iterator();
                if (recordIt.hasNext()) {
                    record = (Record)recordIt.next();
                    Schema schema = rowSchema = record.get(2) != null ? spec.schema() : null;
                }
                if (record == null) break block15;
                try (PositionDeleteWriter<Record> writer = posDeleteReaderWriter.writer(outputFile, deleteFile.format(), spec, deleteFile.partition(), rowSchema);){
                    writer.write(RewriteTablePathUtil.newPositionDeleteRecord(record, sourcePrefix, targetPrefix));
                    while (recordIt.hasNext()) {
                        record = (Record)recordIt.next();
                        if (record == null) continue;
                        writer.write(RewriteTablePathUtil.newPositionDeleteRecord(record, sourcePrefix, targetPrefix));
                    }
                }
            }
        }
    }

    private static PositionDelete newPositionDeleteRecord(Record record, String sourcePrefix, String targetPrefix) {
        PositionDelete delete = PositionDelete.create();
        String oldPath = (String)record.get(0);
        if (!oldPath.startsWith(sourcePrefix)) {
            throw new UnsupportedOperationException("Expected delete file to be under the source prefix: " + sourcePrefix + " but was " + oldPath);
        }
        String newPath = RewriteTablePathUtil.newPath(oldPath, sourcePrefix, targetPrefix);
        delete.set(newPath, (Long)record.get(1), record.get(2));
        return delete;
    }

    public static String newPath(String path, String sourcePrefix, String targetPrefix) {
        return RewriteTablePathUtil.combinePaths(targetPrefix, RewriteTablePathUtil.relativize(path, sourcePrefix));
    }

    public static String combinePaths(String absolutePath, String relativePath) {
        return RewriteTablePathUtil.maybeAppendFileSeparator(absolutePath) + relativePath;
    }

    public static String fileName(String path) {
        String filename = path;
        int lastIndex = path.lastIndexOf(FILE_SEPARATOR);
        if (lastIndex != -1) {
            filename = path.substring(lastIndex + 1);
        }
        return filename;
    }

    public static String relativize(String path, String prefix) {
        String toRemove = RewriteTablePathUtil.maybeAppendFileSeparator(prefix);
        if (!path.startsWith(toRemove)) {
            throw new IllegalArgumentException(String.format("Path %s does not start with %s", path, toRemove));
        }
        return path.substring(toRemove.length());
    }

    public static String maybeAppendFileSeparator(String path) {
        return path.endsWith(FILE_SEPARATOR) ? path : path + FILE_SEPARATOR;
    }

    @Deprecated
    public static String stagingPath(String originalPath, String stagingDir) {
        return stagingDir + RewriteTablePathUtil.fileName(originalPath);
    }

    public static String stagingPath(String originalPath, String sourcePrefix, String stagingDir) {
        String relativePath = RewriteTablePathUtil.relativize(originalPath, sourcePrefix);
        return RewriteTablePathUtil.combinePaths(stagingDir, relativePath);
    }

    public static class RewriteResult<T>
    implements Serializable {
        private final Set<T> toRewrite = Sets.newHashSet();
        private final Set<Pair<String, String>> copyPlan = Sets.newHashSet();

        public RewriteResult<T> append(RewriteResult<T> r1) {
            this.toRewrite.addAll(r1.toRewrite);
            this.copyPlan.addAll(r1.copyPlan);
            return this;
        }

        public Set<T> toRewrite() {
            return this.toRewrite;
        }

        public Set<Pair<String, String>> copyPlan() {
            return this.copyPlan;
        }
    }

    public static interface PositionDeleteReaderWriter
    extends Serializable {
        public CloseableIterable<Record> reader(InputFile var1, FileFormat var2, PartitionSpec var3);

        public PositionDeleteWriter<Record> writer(OutputFile var1, FileFormat var2, PartitionSpec var3, StructLike var4, Schema var5) throws IOException;
    }
}

