/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import org.apache.iceberg.ImmutableGenericPartitionStatisticsFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class PartitionStatisticsFileParser {
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String STATISTICS_PATH = "statistics-path";
    private static final String FILE_SIZE_IN_BYTES = "file-size-in-bytes";

    private PartitionStatisticsFileParser() {
    }

    public static String toJson(PartitionStatisticsFile partitionStatisticsFile) {
        return PartitionStatisticsFileParser.toJson(partitionStatisticsFile, false);
    }

    public static String toJson(PartitionStatisticsFile partitionStatisticsFile, boolean pretty) {
        return JsonUtil.generate(gen -> PartitionStatisticsFileParser.toJson(partitionStatisticsFile, gen), pretty);
    }

    public static void toJson(PartitionStatisticsFile statisticsFile, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SNAPSHOT_ID, statisticsFile.snapshotId());
        generator.writeStringField(STATISTICS_PATH, statisticsFile.path());
        generator.writeNumberField(FILE_SIZE_IN_BYTES, statisticsFile.fileSizeInBytes());
        generator.writeEndObject();
    }

    static PartitionStatisticsFile fromJson(JsonNode node) {
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        String path = JsonUtil.getString(STATISTICS_PATH, node);
        long fileSizeInBytes = JsonUtil.getLong(FILE_SIZE_IN_BYTES, node);
        return ImmutableGenericPartitionStatisticsFile.builder().snapshotId(snapshotId).path(path).fileSizeInBytes(fileSizeInBytes).build();
    }
}

