/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFile;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.InheritableMetadata;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class InheritableMetadataFactory {
    private static final InheritableMetadata EMPTY = new EmptyInheritableMetadata();

    private InheritableMetadataFactory() {
    }

    static InheritableMetadata empty() {
        return EMPTY;
    }

    static InheritableMetadata fromManifest(ManifestFile manifest) {
        Preconditions.checkArgument(manifest.snapshotId() != null, "Cannot read from ManifestFile with null (unassigned) snapshot ID");
        return new BaseInheritableMetadata(manifest.partitionSpecId(), manifest.snapshotId(), manifest.sequenceNumber(), manifest.path());
    }

    static InheritableMetadata forCopy(long snapshotId) {
        return new CopyMetadata(snapshotId);
    }

    static class BaseInheritableMetadata
    implements InheritableMetadata {
        private final int specId;
        private final long snapshotId;
        private final long sequenceNumber;
        private final String manifestLocation;

        private BaseInheritableMetadata(int specId, long snapshotId, long sequenceNumber, String manifestLocation) {
            this.specId = specId;
            this.snapshotId = snapshotId;
            this.sequenceNumber = sequenceNumber;
            this.manifestLocation = manifestLocation;
        }

        @Override
        public <F extends ContentFile<F>> ManifestEntry<F> apply(ManifestEntry<F> manifestEntry) {
            if (manifestEntry.snapshotId() == null) {
                manifestEntry.setSnapshotId(this.snapshotId);
            }
            if (manifestEntry.dataSequenceNumber() == null && (this.sequenceNumber == 0L || manifestEntry.status() == ManifestEntry.Status.ADDED)) {
                manifestEntry.setDataSequenceNumber(this.sequenceNumber);
            }
            if (manifestEntry.fileSequenceNumber() == null && (this.sequenceNumber == 0L || manifestEntry.status() == ManifestEntry.Status.ADDED)) {
                manifestEntry.setFileSequenceNumber(this.sequenceNumber);
            }
            if (manifestEntry.file() instanceof BaseFile) {
                BaseFile file = (BaseFile)manifestEntry.file();
                file.setSpecId(this.specId);
                file.setDataSequenceNumber(manifestEntry.dataSequenceNumber());
                file.setFileSequenceNumber(manifestEntry.fileSequenceNumber());
                file.setManifestLocation(this.manifestLocation);
            }
            return manifestEntry;
        }
    }

    static class CopyMetadata
    implements InheritableMetadata {
        private final long snapshotId;

        private CopyMetadata(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public <F extends ContentFile<F>> ManifestEntry<F> apply(ManifestEntry<F> manifestEntry) {
            manifestEntry.setSnapshotId(this.snapshotId);
            return manifestEntry;
        }
    }

    static class EmptyInheritableMetadata
    implements InheritableMetadata {
        private EmptyInheritableMetadata() {
        }

        @Override
        public <F extends ContentFile<F>> ManifestEntry<F> apply(ManifestEntry<F> manifestEntry) {
            if (manifestEntry.snapshotId() == null) {
                throw new IllegalArgumentException("Entries must have explicit snapshot ids if inherited metadata is empty");
            }
            return manifestEntry;
        }
    }
}

