/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Delegates;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.Types;

class GenericManifestEntry<F extends ContentFile<F>>
implements ManifestEntry<F>,
IndexedRecord,
SpecificData.SchemaConstructable,
StructLike {
    private static final ManifestEntry.Status[] STATUS_VALUES = ManifestEntry.Status.values();
    private final Schema schema;
    private ManifestEntry.Status status = ManifestEntry.Status.EXISTING;
    private Long snapshotId = null;
    private Long dataSequenceNumber = null;
    private Long fileSequenceNumber = null;
    private F file = null;

    GenericManifestEntry(Schema schema) {
        this.schema = schema;
    }

    GenericManifestEntry(Types.StructType schema) {
        this.schema = AvroSchemaUtil.convert(schema, "manifest_entry");
    }

    private GenericManifestEntry(GenericManifestEntry<F> toCopy, boolean fullCopy) {
        this.schema = toCopy.schema;
        this.status = toCopy.status;
        this.snapshotId = toCopy.snapshotId;
        this.dataSequenceNumber = toCopy.dataSequenceNumber;
        this.fileSequenceNumber = toCopy.fileSequenceNumber;
        this.file = (ContentFile)toCopy.file().copy(fullCopy);
    }

    ManifestEntry<F> wrapExisting(ManifestEntry<F> entry) {
        return this.wrapExisting(entry.snapshotId(), entry.dataSequenceNumber(), entry.fileSequenceNumber(), entry.file());
    }

    ManifestEntry<F> wrapExisting(Long newSnapshotId, Long newDataSequenceNumber, Long newFileSequenceNumber, F newFile) {
        this.status = ManifestEntry.Status.EXISTING;
        this.snapshotId = newSnapshotId;
        this.dataSequenceNumber = newDataSequenceNumber;
        this.fileSequenceNumber = newFileSequenceNumber;
        this.file = newFile;
        return this;
    }

    ManifestEntry<F> wrapAppend(Long newSnapshotId, F newFile) {
        return this.wrapAppend(newSnapshotId, null, newFile);
    }

    ManifestEntry<F> wrapAppend(Long newSnapshotId, Long newDataSequenceNumber, F newFile) {
        this.status = ManifestEntry.Status.ADDED;
        this.snapshotId = newSnapshotId;
        this.dataSequenceNumber = newDataSequenceNumber;
        this.fileSequenceNumber = null;
        this.file = Delegates.suppressFirstRowId(newFile);
        return this;
    }

    ManifestEntry<F> wrapDelete(Long newSnapshotId, ManifestEntry<F> entry) {
        return this.wrapDelete(newSnapshotId, entry.dataSequenceNumber(), entry.fileSequenceNumber(), entry.file());
    }

    ManifestEntry<F> wrapDelete(Long newSnapshotId, Long newDataSequenceNumber, Long newFileSequenceNumber, F newFile) {
        this.status = ManifestEntry.Status.DELETED;
        this.snapshotId = newSnapshotId;
        this.dataSequenceNumber = newDataSequenceNumber;
        this.fileSequenceNumber = newFileSequenceNumber;
        this.file = newFile;
        return this;
    }

    @Override
    public ManifestEntry.Status status() {
        return this.status;
    }

    @Override
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Long dataSequenceNumber() {
        return this.dataSequenceNumber;
    }

    @Override
    public Long fileSequenceNumber() {
        return this.fileSequenceNumber;
    }

    @Override
    public F file() {
        return this.file;
    }

    @Override
    public ManifestEntry<F> copy() {
        return new GenericManifestEntry<F>(this, true);
    }

    @Override
    public ManifestEntry<F> copyWithoutStats() {
        return new GenericManifestEntry<F>(this, false);
    }

    @Override
    public void setSnapshotId(long newSnapshotId) {
        this.snapshotId = newSnapshotId;
    }

    @Override
    public void setDataSequenceNumber(long newDataSequenceNumber) {
        this.dataSequenceNumber = newDataSequenceNumber;
    }

    @Override
    public void setFileSequenceNumber(long newFileSequenceNumber) {
        this.fileSequenceNumber = newFileSequenceNumber;
    }

    @Override
    public void put(int i, Object v) {
        switch (i) {
            case 0: {
                this.status = STATUS_VALUES[(Integer)v];
                return;
            }
            case 1: {
                this.snapshotId = (Long)v;
                return;
            }
            case 2: {
                this.dataSequenceNumber = (Long)v;
                return;
            }
            case 3: {
                this.fileSequenceNumber = (Long)v;
                return;
            }
            case 4: {
                this.file = (ContentFile)v;
                return;
            }
        }
    }

    @Override
    public <T> void set(int pos, T value) {
        this.put(pos, value);
    }

    @Override
    public Object get(int i) {
        switch (i) {
            case 0: {
                return this.status.id();
            }
            case 1: {
                return this.snapshotId;
            }
            case 2: {
                return this.dataSequenceNumber;
            }
            case 3: {
                return this.fileSequenceNumber;
            }
            case 4: {
                return this.file;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int size() {
        return 5;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("status", (Object)this.status).add("snapshot_id", this.snapshotId).add("data_sequence_number", this.dataSequenceNumber).add("file_sequence_number", this.fileSequenceNumber).add("file", this.file).toString();
    }
}

