/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFileParser;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileIOParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.util.PartitionUtil;

class FilesTableTaskParser {
    private static final String FILE_IO = "file-io";
    private static final String SPECS = "partition-specs";
    private static final String SCHEMA = "schema";
    private static final String PROJECTION = "projection";
    private static final String RESIDUAL = "residual-filter";
    private static final String MANIFEST = "manifest-file";

    private FilesTableTaskParser() {
    }

    static void toJson(BaseFilesTable.ManifestReadTask task, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(task != null, "Invalid files task: null");
        Preconditions.checkArgument(generator != null, "Invalid JSON generator: null");
        generator.writeFieldName(SCHEMA);
        SchemaParser.toJson(task.dataTableSchema(), generator);
        generator.writeFieldName(PROJECTION);
        SchemaParser.toJson(task.projection(), generator);
        generator.writeFieldName(FILE_IO);
        FileIOParser.toJson(task.io(), generator);
        generator.writeArrayFieldStart(SPECS);
        for (PartitionSpec spec : task.specsById().values()) {
            PartitionSpecParser.toJson(spec, generator);
        }
        generator.writeEndArray();
        generator.writeFieldName(RESIDUAL);
        ExpressionParser.toJson(task.residual(), generator);
        generator.writeFieldName(MANIFEST);
        ManifestFileParser.toJson(task.manifest(), generator);
    }

    static BaseFilesTable.ManifestReadTask fromJson(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode != null, "Invalid JSON node for files task: null");
        Preconditions.checkArgument(jsonNode.isObject(), "Invalid JSON node for files task: non-object (%s)", (Object)jsonNode);
        Schema dataTableSchema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, jsonNode));
        Schema projection = SchemaParser.fromJson(JsonUtil.get(PROJECTION, jsonNode));
        FileIO fileIO = FileIOParser.fromJson(JsonUtil.get(FILE_IO, jsonNode), null);
        JsonNode specsArray = JsonUtil.get(SPECS, jsonNode);
        Preconditions.checkArgument(specsArray.isArray(), "Invalid JSON node for partition specs: non-array (%s)", (Object)specsArray);
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (JsonNode specNode : specsArray) {
            PartitionSpec spec = PartitionSpecParser.fromJson(dataTableSchema, specNode);
            specsBuilder.add(spec);
        }
        Map<Integer, PartitionSpec> specsById = PartitionUtil.indexSpecs((List<PartitionSpec>)((Object)specsBuilder.build()));
        Expression residualFilter = ExpressionParser.fromJson(JsonUtil.get(RESIDUAL, jsonNode));
        ManifestFile manifestFile = ManifestFileParser.fromJson(JsonUtil.get(MANIFEST, jsonNode));
        return new BaseFilesTable.ManifestReadTask(dataTableSchema, fileIO, specsById, manifestFile, projection, residualFilter);
    }
}

