/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import org.apache.iceberg.encryption.BaseEncryptedKey;
import org.apache.iceberg.encryption.EncryptedKey;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.JsonUtil;

public class EncryptedKeyParser {
    private static final String KEY_ID = "key-id";
    private static final String KEY_METADATA = "encrypted-key-metadata";
    private static final String ENCRYPTED_BY_ID = "encrypted-by-id";
    private static final String PROPERTIES = "properties";

    private EncryptedKeyParser() {
    }

    public static String toJson(EncryptedKey key) {
        return EncryptedKeyParser.toJson(key, true);
    }

    public static String toJson(EncryptedKey key, boolean pretty) {
        return JsonUtil.generate(gen -> EncryptedKeyParser.toJson(key, gen), pretty);
    }

    static void toJson(EncryptedKey key, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(KEY_ID, key.keyId());
        generator.writeStringField(KEY_METADATA, Base64.getEncoder().encodeToString(ByteBuffers.toByteArray(key.encryptedKeyMetadata())));
        JsonUtil.writeStringFieldIfPresent(ENCRYPTED_BY_ID, key.encryptedById(), generator);
        if (key.properties() != null && !key.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, key.properties(), generator);
        }
        generator.writeEndObject();
    }

    public static EncryptedKey fromJson(String json) {
        return JsonUtil.parse(json, EncryptedKeyParser::fromJson);
    }

    static EncryptedKey fromJson(JsonNode node) {
        String keyId = JsonUtil.getString(KEY_ID, node);
        ByteBuffer keyMetadata = ByteBuffer.wrap(Base64.getDecoder().decode(JsonUtil.getString(KEY_METADATA, node)));
        String encryptedById = JsonUtil.getStringOrNull(ENCRYPTED_BY_ID, node);
        Map<Object, Object> properties = node.has(PROPERTIES) ? JsonUtil.getStringMap(PROPERTIES, node) : ImmutableMap.of();
        return new BaseEncryptedKey(keyId, keyMetadata, encryptedById, properties);
    }
}

