/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchR;
import org.apache.datasketches.quantiles.DoublesByteArrayImpl;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.DoublesSketchIterator;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;

public abstract class DoublesSketch
implements QuantilesDoublesAPI {
    static Random rand = new Random();
    final int k_;
    DoublesSketchSortedView doublesSV = null;

    DoublesSketch(int k) {
        ClassicUtil.checkK(k);
        this.k_ = k;
    }

    static synchronized void setRandom(long seed) {
        rand = new Random(seed);
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public static DoublesSketch heapify(Memory srcMem) {
        if (ClassicUtil.checkIsCompactMemory(srcMem)) {
            return CompactDoublesSketch.heapify(srcMem);
        }
        return UpdateDoublesSketch.heapify(srcMem);
    }

    public static DoublesSketch wrap(Memory srcMem) {
        if (ClassicUtil.checkIsCompactMemory(srcMem)) {
            return DirectCompactDoublesSketch.wrapInstance(srcMem);
        }
        return DirectUpdateDoublesSketchR.wrapInstance(srcMem);
    }

    @Override
    public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public abstract double getMaxItem();

    @Override
    public abstract double getMinItem();

    @Override
    public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getQuantile(rank, searchCrit);
    }

    @Override
    public double[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        double[] quantiles = new double[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.doublesSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public double getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - DoublesSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public double getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + DoublesSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.doublesSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - DoublesSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + DoublesSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double[] getRanks(double[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.doublesSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public abstract long getN();

    @Override
    public double getNormalizedRankError(boolean pmf) {
        return DoublesSketch.getNormalizedRankError(this.k_, pmf);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return ClassicUtil.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return ClassicUtil.getKFromEpsilon(epsilon, pmf);
    }

    @Override
    public abstract boolean hasMemory();

    @Override
    public abstract boolean isDirect();

    @Override
    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    @Override
    public abstract boolean isReadOnly();

    public boolean isSameResource(Memory that) {
        return false;
    }

    @Override
    public byte[] toByteArray() {
        if (this.isCompact()) {
            return this.toByteArray(true);
        }
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean compact) {
        return DoublesByteArrayImpl.toByteArray(this, compact, compact);
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean withLevels, boolean withLevelsAndItems) {
        return DoublesUtil.toString(withLevels, withLevelsAndItems, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, true);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem, true);
    }

    public DoublesSketch downSample(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        return this.downSampleInternal(srcSketch, smallerK, dstMem);
    }

    @Override
    public int getNumRetained() {
        return ClassicUtil.computeRetainedItems(this.getK(), this.getN());
    }

    public int getCurrentCompactSerializedSizeBytes() {
        return DoublesSketch.getCompactSerialiedSizeBytes(this.getK(), this.getN());
    }

    public static int getCompactSerialiedSizeBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPreLongs = ClassicUtil.MAX_PRELONGS + 2;
        return metaPreLongs + ClassicUtil.computeRetainedItems(k, n) << 3;
    }

    @Override
    public int getSerializedSizeBytes() {
        if (this.isCompact()) {
            return this.getCurrentCompactSerializedSizeBytes();
        }
        return this.getCurrentUpdatableSerializedSizeBytes();
    }

    public int getCurrentUpdatableSerializedSizeBytes() {
        return DoublesSketch.getUpdatableStorageBytes(this.getK(), this.getN());
    }

    public static int getUpdatableStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPre = ClassicUtil.MAX_PRELONGS + 2;
        int totLevels = ClassicUtil.computeNumLevelsNeeded(k, n);
        if (n <= (long)k) {
            int ceil = Math.max(Util.ceilingPowerOf2((int)n), 4);
            return metaPre + ceil << 3;
        }
        return metaPre + (2 + totLevels) * k << 3;
    }

    public void putMemory(WritableMemory dstMem) {
        this.putMemory(dstMem, true);
    }

    public void putMemory(WritableMemory dstMem, boolean compact) {
        if (this.hasMemory() && this.isCompact() == compact) {
            WritableMemory srcMem = this.getMemory();
            srcMem.copyTo(0L, dstMem, 0L, this.getSerializedSizeBytes());
        } else {
            byte[] byteArr = this.toByteArray(compact);
            int arrLen = byteArr.length;
            long memCap = dstMem.getCapacity();
            if (memCap < (long)arrLen) {
                throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
            }
            dstMem.putByteArray(0L, byteArr, 0, arrLen);
        }
    }

    @Override
    public QuantilesDoublesSketchIterator iterator() {
        return new DoublesSketchIterator(this, this.getBitPattern());
    }

    @Override
    public abstract void reset();

    UpdateDoublesSketch downSampleInternal(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        UpdateDoublesSketch newSketch;
        UpdateDoublesSketch updateDoublesSketch = newSketch = dstMem == null ? HeapUpdateDoublesSketch.newInstance(smallerK) : DirectUpdateDoublesSketch.newInstance(smallerK, dstMem);
        if (srcSketch.isEmpty()) {
            return newSketch;
        }
        DoublesMergeImpl.downSamplingMergeInto(srcSketch, newSketch);
        return newSketch;
    }

    abstract boolean isCompact();

    abstract int getBaseBufferCount();

    abstract long getBitPattern();

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();

    abstract WritableMemory getMemory();

    @Override
    public final DoublesSketchSortedView getSortedView() {
        return this.refreshSortedView();
    }

    private final DoublesSketchSortedView refreshSortedView() {
        return this.doublesSV == null ? (this.doublesSV = this.getSV()) : this.doublesSV;
    }

    private DoublesSketchSortedView getSV() {
        long totalN = this.getN();
        if (this.isEmpty() || totalN == 0L) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int numQuantiles = this.getNumRetained();
        double[] svQuantiles = new double[numQuantiles];
        long[] svCumWeights = new long[numQuantiles];
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(this);
        DoublesSketch.populateFromDoublesSketch(this.getK(), totalN, this.getBitPattern(), sketchAccessor, svQuantiles, svCumWeights);
        DoublesSketch.blockyTandemMergeSort(svQuantiles, svCumWeights, numQuantiles, this.getK());
        if (DoublesSketch.convertToCumulative(svCumWeights) != totalN) {
            throw new SketchesStateException("Sorted View is misconfigured. TotalN does not match cumWeights.");
        }
        return new DoublesSketchSortedView(svQuantiles, svCumWeights, this);
    }

    private static final void populateFromDoublesSketch(int k, long totalN, long bitPattern, DoublesSketchAccessor sketchAccessor, double[] svQuantiles, long[] svCumWeights) {
        int i;
        long bits;
        long weight = 1L;
        int index = 0;
        assert (bits == totalN / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight <<= 1;
            if ((bits & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                for (i = 0; i < sketchAccessor.numItems(); ++i) {
                    svQuantiles[index] = sketchAccessor.get(i);
                    svCumWeights[index] = weight;
                    ++index;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = index;
        sketchAccessor.setLevel(-1);
        for (i = 0; i < sketchAccessor.numItems(); ++i) {
            svQuantiles[index] = sketchAccessor.get(i);
            svCumWeights[index] = weight;
            ++index;
        }
        assert (index == svQuantiles.length);
        int numSamples = index;
        Arrays.sort(svQuantiles, startOfBaseBufferBlock, numSamples);
    }

    static void blockyTandemMergeSort(double[] svQuantiles, long[] svCumWts, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] qSrc = Arrays.copyOf(svQuantiles, arrLen);
        long[] cwSrc = Arrays.copyOf(svCumWts, arrLen);
        DoublesSketch.blockyTandemMergeSortRecursion(qSrc, cwSrc, svQuantiles, svCumWts, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] qSrc, long[] cwSrc, double[] qDst, long[] cwDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesSketch.blockyTandemMergeSortRecursion(qDst, cwDst, qSrc, cwSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesSketch.blockyTandemMergeSortRecursion(qDst, cwDst, qSrc, cwSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesSketch.tandemMerge(qSrc, cwSrc, arrStart1, arrLen1, arrStart2, arrLen2, qDst, cwDst, arrStart1);
    }

    private static void tandemMerge(double[] qSrc, long[] cwSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] qDst, long[] cwDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (qSrc[i2] < qSrc[i1]) {
                qDst[i3] = qSrc[i2];
                cwDst[i3] = cwSrc[i2];
                ++i2;
            } else {
                qDst[i3] = qSrc[i1];
                cwDst[i3] = cwSrc[i1];
                ++i1;
            }
            ++i3;
        }
        if (i1 < arrStop1) {
            System.arraycopy(qSrc, i1, qDst, i3, arrStop1 - i1);
            System.arraycopy(cwSrc, i1, cwDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(qSrc, i2, qDst, i3, arrStop2 - i2);
            System.arraycopy(cwSrc, i2, cwDst, i3, arrStop2 - i2);
        }
    }

    private static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }
}

