/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectLongsSketch
extends KllLongsSketch {
    private WritableMemory wmem;
    private MemoryRequestServer memReqSvr;

    KllDirectLongsSketch(KllSketch.SketchStructure sketchStructure, WritableMemory wmem, MemoryRequestServer memReqSvr, KllMemoryValidate memVal) {
        super(sketchStructure);
        this.wmem = wmem;
        this.memReqSvr = memReqSvr;
        this.readOnly = wmem != null && wmem.isReadOnly() || sketchStructure != KllSketch.SketchStructure.UPDATABLE;
        this.levelsArr = memVal.levelsArr;
    }

    static KllDirectLongsSketch newDirectUpdatableInstance(int k, int m4, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        KllPreambleUtil.setMemoryPreInts(dstMem, KllSketch.SketchStructure.UPDATABLE.getPreInts());
        KllPreambleUtil.setMemorySerVer(dstMem, KllSketch.SketchStructure.UPDATABLE.getSerVer());
        KllPreambleUtil.setMemoryFamilyID(dstMem, Family.KLL.getID());
        KllPreambleUtil.setMemoryK(dstMem, k);
        KllPreambleUtil.setMemoryM(dstMem, m4);
        KllPreambleUtil.setMemoryN(dstMem, 0L);
        KllPreambleUtil.setMemoryMinK(dstMem, k);
        KllPreambleUtil.setMemoryNumLevels(dstMem, 1);
        int offset = 20;
        dstMem.putIntArray(offset, new int[]{k, k}, 0, 2);
        dstMem.putLongArray(offset += 8, new long[]{Long.MAX_VALUE, Long.MIN_VALUE}, 0, 2);
        dstMem.putLongArray(offset += 16, new long[k], 0, k);
        KllMemoryValidate memVal = new KllMemoryValidate(dstMem, KllSketch.SketchType.LONGS_SKETCH, null);
        WritableMemory wMem = dstMem;
        return new KllDirectLongsSketch(KllSketch.SketchStructure.UPDATABLE, wMem, memReqSvr, memVal);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "Null";
        }
        return Long.toString(this.getLongItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK(this.wmem);
    }

    @Override
    public long getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wmem.getLong(offset);
    }

    @Override
    long getMaxItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wmem.getLong(offset);
    }

    @Override
    String getMaxItemAsString() {
        long maxItem = this.getMaxItemInternal();
        return Long.toString(maxItem);
    }

    @Override
    public long getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getLong(offset);
    }

    @Override
    long getMinItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getLong(offset);
    }

    @Override
    String getMinItemAsString() {
        long minItem = this.getMinItemInternal();
        return Long.toString(minItem);
    }

    @Override
    void setMaxItem(long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        this.wmem.putLong(offset, item);
    }

    @Override
    void setMinItem(long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.putLong(offset, item);
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN(this.wmem);
    }

    @Override
    long[] getLongItemsArray() {
        int k = this.getK();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new long[k];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            long[] itemsArr = new long[k];
            itemsArr[k - 1] = this.getLongSingleItem();
            return itemsArr;
        }
        int capacityItems = KllHelper.computeTotalItemCapacity(k, this.getM(), this.getNumLevels());
        long[] longItemsArr = new long[capacityItems];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        int shift = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.levelsArr[0] : 0;
        int numItems = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.getNumRetained() : capacityItems;
        this.wmem.getLongArray(offset, longItemsArr, shift, numItems);
        return longItemsArr;
    }

    @Override
    long[] getLongRetainedItemsArray() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new long[0];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return new long[]{this.getLongSingleItem()};
        }
        int numRetained = this.getNumRetained();
        long[] longItemsArr = new long[numRetained];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 + (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 0 : this.levelsArr[0] * 8);
        this.wmem.getLongArray(offset, longItemsArr, 0, numRetained);
        return longItemsArr;
    }

    @Override
    long getLongSingleItem() {
        if (!this.isSingleItem()) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.wmem.getLong(8L);
        }
        int offset = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 : 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (2 + this.getK() - 1) * 8;
        return this.wmem.getLong(offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM(this.wmem);
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr;
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL || this.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return KllPreambleUtil.getMemoryMinK(this.wmem);
        }
        return this.getK();
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[16];
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            ByteArrayUtil.putLongLE(bytesOut, 0, Long.MAX_VALUE);
            ByteArrayUtil.putLongLE(bytesOut, 8, Long.MIN_VALUE);
            return bytesOut;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            this.wmem.getByteArray(offset, bytesOut, 0, 8);
            ByteArrayUtil.copyBytes(bytesOut, 0, bytesOut, 8, 8);
            return bytesOut;
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.getByteArray(offset, bytesOut, 0, 8);
        this.wmem.getByteArray(offset + 8, bytesOut, 8, 8);
        return bytesOut;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new byte[0];
        }
        long[] lngArr = this.getLongRetainedItemsArray();
        byte[] lngByteArr = new byte[lngArr.length * 8];
        WritableMemory wmem2 = WritableMemory.writableWrap(lngByteArr);
        wmem2.putLongArray(0L, lngArr, 0, lngArr.length);
        return lngByteArr;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        long[] lngArr = this.getLongItemsArray();
        byte[] lngByteArr = new byte[lngArr.length * 8];
        WritableMemory wmem2 = WritableMemory.writableWrap(lngByteArr);
        wmem2.putLongArray(0L, lngArr, 0, lngArr.length);
        return lngByteArr;
    }

    @Override
    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    void incN(int increment) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, KllPreambleUtil.getMemoryN(this.wmem) + (long)increment);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int numLevels = KllPreambleUtil.getMemoryNumLevels(this.wmem);
        KllPreambleUtil.setMemoryNumLevels(this.wmem, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag(this.wmem);
    }

    @Override
    void setLongItemsArray(long[] longItems) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        this.wmem.putLongArray(offset, longItems, 0, longItems.length);
    }

    @Override
    void setLongItemsArrayAt(int index, long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        this.wmem.putLong(offset, item);
    }

    @Override
    void setLongItemsArrayAt(int index, long[] items, int srcOffset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        this.wmem.putLongArray(offset, items, srcOffset, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(this.wmem, sorted);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryMinK(this.wmem, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryNumLevels(this.wmem, numLevels);
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
        this.wmem = wmem;
    }

    static final class KllDirectCompactLongsSketch
    extends KllDirectLongsSketch {
        KllDirectCompactLongsSketch(KllSketch.SketchStructure sketchStructure, Memory srcMem, KllMemoryValidate memVal) {
            super(sketchStructure, (WritableMemory)srcMem, null, memVal);
        }
    }
}

