/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectDoublesSketch
extends KllDoublesSketch {
    private WritableMemory wmem;
    private MemoryRequestServer memReqSvr;

    KllDirectDoublesSketch(KllSketch.SketchStructure sketchStructure, WritableMemory wmem, MemoryRequestServer memReqSvr, KllMemoryValidate memVal) {
        super(sketchStructure);
        this.wmem = wmem;
        this.memReqSvr = memReqSvr;
        this.readOnly = wmem != null && wmem.isReadOnly() || sketchStructure != KllSketch.SketchStructure.UPDATABLE;
        this.levelsArr = memVal.levelsArr;
    }

    static KllDirectDoublesSketch newDirectUpdatableInstance(int k, int m4, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        KllPreambleUtil.setMemoryPreInts(dstMem, KllSketch.SketchStructure.UPDATABLE.getPreInts());
        KllPreambleUtil.setMemorySerVer(dstMem, KllSketch.SketchStructure.UPDATABLE.getSerVer());
        KllPreambleUtil.setMemoryFamilyID(dstMem, Family.KLL.getID());
        KllPreambleUtil.setMemoryK(dstMem, k);
        KllPreambleUtil.setMemoryM(dstMem, m4);
        KllPreambleUtil.setMemoryN(dstMem, 0L);
        KllPreambleUtil.setMemoryMinK(dstMem, k);
        KllPreambleUtil.setMemoryNumLevels(dstMem, 1);
        int offset = 20;
        dstMem.putIntArray(offset, new int[]{k, k}, 0, 2);
        dstMem.putDoubleArray(offset += 8, new double[]{Double.NaN, Double.NaN}, 0, 2);
        dstMem.putDoubleArray(offset += 16, new double[k], 0, k);
        KllMemoryValidate memVal = new KllMemoryValidate(dstMem, KllSketch.SketchType.DOUBLES_SKETCH, null);
        WritableMemory wMem = dstMem;
        return new KllDirectDoublesSketch(KllSketch.SketchStructure.UPDATABLE, wMem, memReqSvr, memVal);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "NaN";
        }
        return Double.toString(this.getDoubleItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK(this.wmem);
    }

    @Override
    public double getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wmem.getDouble(offset);
    }

    @Override
    double getMaxItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Double.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wmem.getDouble(offset);
    }

    @Override
    String getMaxItemAsString() {
        double maxItem = this.getMaxItemInternal();
        return Double.toString(maxItem);
    }

    @Override
    public double getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getDouble(offset);
    }

    @Override
    double getMinItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Double.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getDoubleSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getDouble(offset);
    }

    @Override
    String getMinItemAsString() {
        double minItem = this.getMinItemInternal();
        return Double.toString(minItem);
    }

    @Override
    void setMaxItem(double item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        this.wmem.putDouble(offset, item);
    }

    @Override
    void setMinItem(double item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.putDouble(offset, item);
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN(this.wmem);
    }

    @Override
    double[] getDoubleItemsArray() {
        int k = this.getK();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new double[k];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            double[] itemsArr = new double[k];
            itemsArr[k - 1] = this.getDoubleSingleItem();
            return itemsArr;
        }
        int capacityItems = KllHelper.computeTotalItemCapacity(k, this.getM(), this.getNumLevels());
        double[] doubleItemsArr = new double[capacityItems];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        int shift = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.levelsArr[0] : 0;
        int numItems = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.getNumRetained() : capacityItems;
        this.wmem.getDoubleArray(offset, doubleItemsArr, shift, numItems);
        return doubleItemsArr;
    }

    @Override
    double[] getDoubleRetainedItemsArray() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new double[0];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return new double[]{this.getDoubleSingleItem()};
        }
        int numRetained = this.getNumRetained();
        double[] doubleItemsArr = new double[numRetained];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 + (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 0 : this.levelsArr[0] * 8);
        this.wmem.getDoubleArray(offset, doubleItemsArr, 0, numRetained);
        return doubleItemsArr;
    }

    @Override
    double getDoubleSingleItem() {
        if (!this.isSingleItem()) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.wmem.getDouble(8L);
        }
        int offset = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 : 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (2 + this.getK() - 1) * 8;
        return this.wmem.getDouble(offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM(this.wmem);
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr;
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL || this.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return KllPreambleUtil.getMemoryMinK(this.wmem);
        }
        return this.getK();
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[16];
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            ByteArrayUtil.putDoubleLE(bytesOut, 0, Double.NaN);
            ByteArrayUtil.putDoubleLE(bytesOut, 8, Double.NaN);
            return bytesOut;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            this.wmem.getByteArray(offset, bytesOut, 0, 8);
            ByteArrayUtil.copyBytes(bytesOut, 0, bytesOut, 8, 8);
            return bytesOut;
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.getByteArray(offset, bytesOut, 0, 8);
        this.wmem.getByteArray(offset + 8, bytesOut, 8, 8);
        return bytesOut;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new byte[0];
        }
        double[] dblArr = this.getDoubleRetainedItemsArray();
        byte[] dblByteArr = new byte[dblArr.length * 8];
        WritableMemory wmem2 = WritableMemory.writableWrap(dblByteArr);
        wmem2.putDoubleArray(0L, dblArr, 0, dblArr.length);
        return dblByteArr;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        double[] dblArr = this.getDoubleItemsArray();
        byte[] dblByteArr = new byte[dblArr.length * 8];
        WritableMemory wmem2 = WritableMemory.writableWrap(dblByteArr);
        wmem2.putDoubleArray(0L, dblArr, 0, dblArr.length);
        return dblByteArr;
    }

    @Override
    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    void incN(int increment) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, KllPreambleUtil.getMemoryN(this.wmem) + (long)increment);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int numLevels = KllPreambleUtil.getMemoryNumLevels(this.wmem);
        KllPreambleUtil.setMemoryNumLevels(this.wmem, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag(this.wmem);
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        this.wmem.putDoubleArray(offset, doubleItems, 0, doubleItems.length);
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        this.wmem.putDouble(offset, item);
    }

    @Override
    void setDoubleItemsArrayAt(int index, double[] items, int srcOffset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        this.wmem.putDoubleArray(offset, items, srcOffset, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(this.wmem, sorted);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryMinK(this.wmem, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryNumLevels(this.wmem, numLevels);
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
        this.wmem = wmem;
    }

    static final class KllDirectCompactDoublesSketch
    extends KllDirectDoublesSketch {
        KllDirectCompactDoublesSketch(KllSketch.SketchStructure sketchStructure, Memory srcMem, KllMemoryValidate memVal) {
            super(sketchStructure, (WritableMemory)srcMem, null, memVal);
        }
    }
}

