/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.DirectAuxHashMap;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.Hll4Array;
import org.apache.datasketches.hll.Hll4Update;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class DirectHll4Array
extends DirectHllArray {
    DirectHll4Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_4, wmem);
        if (PreambleUtil.extractAuxCount(this.mem) > 0) {
            this.putAuxHashMap(new DirectAuxHashMap(this, false), false);
        }
    }

    DirectHll4Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_4, mem);
        int auxCount = PreambleUtil.extractAuxCount(mem);
        if (auxCount > 0) {
            boolean compact = PreambleUtil.extractCompactFlag(mem);
            AuxHashMap auxHashMap = compact ? HeapAuxHashMap.heapify(mem, this.auxStart, lgConfigK, auxCount, compact) : new DirectAuxHashMap(this, false);
            this.putAuxHashMap(auxHashMap, compact);
        }
    }

    @Override
    HllSketchImpl copy() {
        return Hll4Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int newValue = coupon >>> 26;
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = coupon & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll4Array.hll4ArrBytes(this.lgConfigK);
    }

    @Override
    int getNibble(int slotNo) {
        long offset = PreambleUtil.HLL_BYTE_ARR_START + (slotNo >>> 1);
        int theByte = this.mem.getByte(offset);
        if ((slotNo & 1) > 0) {
            theByte >>>= 4;
        }
        return theByte & 0xF;
    }

    @Override
    int getSlotValue(int slotNo) {
        int nib = this.getNibble(slotNo);
        if (nib == 15) {
            AuxHashMap auxHashMap = this.getAuxHashMap();
            return auxHashMap.mustFindValueFor(slotNo);
        }
        return nib + this.getCurMin();
    }

    @Override
    int getUpdatableSerializationBytes() {
        AuxHashMap auxHashMap = this.getAuxHashMap();
        int auxBytes = auxHashMap == null ? 4 << HllUtil.LG_AUX_ARR_INTS[this.lgConfigK] : 4 << auxHashMap.getLgAuxArrInts();
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes() + auxBytes;
    }

    @Override
    PairIterator iterator() {
        return new DirectHll4Iterator(1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        long offset = PreambleUtil.HLL_BYTE_ARR_START + (slotNo >>> 1);
        byte oldValue = this.mem.getByte(offset);
        byte value = (slotNo & 1) == 0 ? (byte)(oldValue & 0xF0 | nibValue & 0xF) : (byte)(oldValue & 0xF | nibValue << 4 & 0xF0);
        this.wmem.putByte(offset, value);
    }

    @Override
    void updateSlotNoKxQ(int slotNo, int newValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotWithKxQ(int slotNo, int newValue) {
        Hll4Update.internalHll4Update(this, slotNo, newValue);
    }

    @Override
    byte[] toCompactByteArray() {
        boolean srcMemIsCompact = PreambleUtil.extractCompactFlag(this.mem);
        int totBytes = this.getCompactSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        WritableMemory memOut = WritableMemory.writableWrap(byteArr);
        if (srcMemIsCompact) {
            this.mem.copyTo(0L, memOut, 0L, totBytes);
            return byteArr;
        }
        this.mem.copyTo(0L, memOut, 0L, this.auxStart);
        if (this.auxHashMap != null) {
            int auxCount = this.auxHashMap.getAuxCount();
            PreambleUtil.insertAuxCount(memOut, auxCount);
            PreambleUtil.insertLgArr(memOut, this.auxHashMap.getLgAuxArrInts());
            PairIterator itr = this.auxHashMap.getIterator();
            int cnt = 0;
            while (itr.nextValid()) {
                PreambleUtil.insertInt(memOut, this.auxStart + (cnt++ << 2), itr.getPair());
            }
            assert (cnt == auxCount);
        }
        PreambleUtil.insertCompactFlag(memOut, true);
        return byteArr;
    }

    @Override
    byte[] toUpdatableByteArray() {
        boolean memIsCompact = PreambleUtil.extractCompactFlag(this.mem);
        int totBytes = this.getUpdatableSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        WritableMemory memOut = WritableMemory.writableWrap(byteArr);
        if (!memIsCompact) {
            this.mem.copyTo(0L, memOut, 0L, totBytes);
            return byteArr;
        }
        HllSketch heapSk = HllSketch.heapify(this.mem);
        return heapSk.toUpdatableByteArray();
    }

    final class DirectHll4Iterator
    extends HllPairIterator {
        DirectHll4Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            return DirectHll4Array.this.getSlotValue(this.index);
        }
    }
}

