/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.CouponHashSet;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class DirectCouponHashSet
extends DirectCouponList {
    DirectCouponHashSet(int lgConfigK, TgtHllType tgtHllType, WritableMemory wmem) {
        super(lgConfigK, tgtHllType, CurMode.SET, wmem);
        assert (wmem.getByte(PreambleUtil.LG_K_BYTE) > 7);
    }

    DirectCouponHashSet(int lgConfigK, TgtHllType tgtHllType, Memory mem) {
        super(lgConfigK, tgtHllType, CurMode.SET, mem);
        assert (mem.getByte(PreambleUtil.LG_K_BYTE) > 7);
    }

    @Override
    CouponHashSet copy() {
        return CouponHashSet.heapifySet(this.mem);
    }

    @Override
    CouponHashSet copyAs(TgtHllType tgtHllType) {
        CouponHashSet clist = CouponHashSet.heapifySet(this.mem);
        return new CouponHashSet(clist, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int index;
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        if ((index = DirectCouponHashSet.find(this.mem, this.getLgCouponArrInts(), coupon)) >= 0) {
            return this;
        }
        PreambleUtil.insertInt(this.wmem, PreambleUtil.HASH_SET_INT_ARR_START + (~index << 2), coupon);
        PreambleUtil.insertHashSetCount(this.wmem, this.getCouponCount() + 1);
        boolean promote = this.checkGrowOrPromote();
        if (!promote) {
            return this;
        }
        return DirectCouponHashSet.promoteListOrSetToHll(this);
    }

    @Override
    int getCouponCount() {
        return PreambleUtil.extractHashSetCount(this.mem);
    }

    @Override
    int getMemDataStart() {
        return PreambleUtil.HASH_SET_INT_ARR_START;
    }

    @Override
    int getPreInts() {
        return 3;
    }

    private boolean checkGrowOrPromote() {
        int lgCouponArrInts = this.getLgCouponArrInts();
        if (4 * this.getCouponCount() > 3 * (1 << lgCouponArrInts)) {
            if (lgCouponArrInts == this.getLgConfigK() - 3) {
                return true;
            }
            PreambleUtil.insertLgArr(this.wmem, ++lgCouponArrInts);
            DirectCouponHashSet.growHashSet(this.wmem, lgCouponArrInts);
        }
        return false;
    }

    private static final void growHashSet(WritableMemory wmem, int tgtLgCouponArrSize) {
        int tgtArrSize = 1 << tgtLgCouponArrSize;
        int[] tgtCouponIntArr = new int[tgtArrSize];
        int oldLen = 1 << PreambleUtil.extractLgArr(wmem);
        for (int i = 0; i < oldLen; ++i) {
            int fetched = PreambleUtil.extractInt(wmem, PreambleUtil.HASH_SET_INT_ARR_START + (i << 2));
            if (fetched == 0) continue;
            int idx = DirectCouponHashSet.find(tgtCouponIntArr, tgtLgCouponArrSize, fetched);
            if (idx < 0) {
                tgtCouponIntArr[idx ^ 0xFFFFFFFF] = fetched;
                continue;
            }
            throw new SketchesStateException("Error: found duplicate.");
        }
        wmem.clear(PreambleUtil.HASH_SET_INT_ARR_START, tgtArrSize << 2);
        wmem.putIntArray(PreambleUtil.HASH_SET_INT_ARR_START, tgtCouponIntArr, 0, tgtArrSize);
    }

    private static final int find(Memory mem, int lgArr, int coupon) {
        int stride;
        int probe;
        int arrMask = (1 << lgArr) - 1;
        int loopIndex = probe = coupon & arrMask;
        do {
            int couponAtIndex;
            if ((couponAtIndex = PreambleUtil.extractInt(mem, PreambleUtil.HASH_SET_INT_ARR_START + (probe << 2))) == 0) {
                return ~probe;
            }
            if (coupon != couponAtIndex) continue;
            return probe;
        } while ((probe = probe + (stride = (coupon & 0x3FFFFFF) >>> lgArr | 1) & arrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }
}

