/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class ArrayOfBooleansSerDe
extends ArrayOfItemsSerDe<Boolean> {
    public static int computeBytesNeeded(int arrayLength) {
        return (arrayLength >>> 3) + ((arrayLength & 7) > 0 ? 1 : 0);
    }

    @Override
    public byte[] serializeToByteArray(Boolean item) {
        Objects.requireNonNull(item, "Item must not be null");
        byte[] bytes = new byte[]{item != false ? (byte)1 : 0};
        return bytes;
    }

    @Override
    public byte[] serializeToByteArray(Boolean[] items) {
        Objects.requireNonNull(items, "Items must not be null");
        int bytesNeeded = ArrayOfBooleansSerDe.computeBytesNeeded(items.length);
        byte[] bytes = new byte[bytesNeeded];
        WritableMemory mem = WritableMemory.writableWrap(bytes);
        byte val = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].booleanValue()) {
                val = (byte)(val | 1 << (i & 7));
            }
            if ((i & 7) != 7) continue;
            mem.putByte(i >>> 3, val);
            val = 0;
        }
        if ((items.length & 7) > 0) {
            mem.putByte(bytesNeeded - 1, val);
        }
        return bytes;
    }

    public Boolean[] deserializeFromMemory(Memory mem, int numItems) {
        return this.deserializeFromMemory(mem, 0L, numItems);
    }

    public Boolean[] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
        Objects.requireNonNull(mem, "Memory must not be null");
        if (numItems <= 0) {
            return new Boolean[0];
        }
        int numBytes = ArrayOfBooleansSerDe.computeBytesNeeded(numItems);
        Util.checkBounds(offsetBytes, numBytes, mem.getCapacity());
        Boolean[] array = new Boolean[numItems];
        int srcVal = 0;
        int b = 0;
        for (int i = 0; i < numItems; ++i) {
            if ((i & 7) == 0) {
                srcVal = mem.getByte(offsetBytes + (long)b++);
            }
            array[i] = (srcVal >>> (i & 7) & 1) == 1;
        }
        return array;
    }

    @Override
    public int sizeOf(Boolean item) {
        Objects.requireNonNull(item, "Item must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(1);
    }

    @Override
    public int sizeOf(Boolean[] items) {
        Objects.requireNonNull(items, "Item must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(items.length);
    }

    @Override
    public int sizeOf(Memory mem, long offsetBytes, int numItems) {
        Objects.requireNonNull(mem, "Memory must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(numItems);
    }

    @Override
    public String toString(Boolean item) {
        if (item == null) {
            return "null";
        }
        return item != false ? "true" : "false";
    }

    @Override
    public Class<Boolean> getClassOfT() {
        return Boolean.class;
    }
}

