/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.nio.ByteBuffer;
import org.apache.arrow.vector.FieldVector;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedValuesReader;
import org.apache.iceberg.parquet.ValuesAsBytesReader;
import org.apache.parquet.io.api.Binary;

class VectorizedPlainValuesReader
extends ValuesAsBytesReader
implements VectorizedValuesReader {
    VectorizedPlainValuesReader() {
    }

    @Override
    public byte readByte() {
        return (byte)this.readInteger();
    }

    @Override
    public short readShort() {
        return (short)this.readInteger();
    }

    @Override
    public Binary readBinary(int len) {
        ByteBuffer buffer = this.getBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray((byte[])bytes);
    }

    private void readValues(int total, FieldVector vec, int rowId, int typeWidth) {
        ByteBuffer buffer = this.getBuffer(total * typeWidth);
        vec.getDataBuffer().setBytes((long)rowId * (long)typeWidth, buffer);
    }

    @Override
    public void readIntegers(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 4);
    }

    @Override
    public void readLongs(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 8);
    }

    @Override
    public void readFloats(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 4);
    }

    @Override
    public void readDoubles(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 8);
    }
}

