/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.parquet.BaseVectorizedParquetValuesReader;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedDictionaryEncodedParquetValuesReader;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedValuesReader;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.column.Dictionary;

public final class VectorizedParquetDefinitionLevelReader
extends BaseVectorizedParquetValuesReader {
    public VectorizedParquetDefinitionLevelReader(int bitWidth, int maxDefLevel, boolean setArrowValidityVector) {
        super(bitWidth, maxDefLevel, setArrowValidityVector);
    }

    public VectorizedParquetDefinitionLevelReader(int bitWidth, int maxDefLevel, boolean readLength, boolean setArrowValidityVector) {
        super(bitWidth, maxDefLevel, readLength, setArrowValidityVector);
    }

    private void setNull(NullabilityHolder nullabilityHolder, int bufferIdx, ArrowBuf validityBuffer) {
        nullabilityHolder.setNull(bufferIdx);
        if (this.setArrowValidityVector) {
            BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)bufferIdx, (int)0);
        }
    }

    private void setNulls(NullabilityHolder nullabilityHolder, int idx, int numValues, ArrowBuf validityBuffer) {
        nullabilityHolder.setNulls(idx, numValues);
        if (this.setArrowValidityVector) {
            for (int i = 0; i < numValues; ++i) {
                BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)(idx + i), (int)0);
            }
        }
    }

    LongReader longReader() {
        return new LongReader();
    }

    DoubleReader doubleReader() {
        return new DoubleReader();
    }

    FloatReader floatReader() {
        return new FloatReader();
    }

    IntegerReader integerReader() {
        return new IntegerReader();
    }

    TimestampMillisReader timestampMillisReader() {
        return new TimestampMillisReader();
    }

    TimestampInt96Reader timestampInt96Reader() {
        return new TimestampInt96Reader();
    }

    FixedSizeBinaryReader fixedSizeBinaryReader() {
        return new FixedSizeBinaryReader();
    }

    VarWidthReader varWidthReader() {
        return new VarWidthReader();
    }

    BooleanReader booleanReader() {
        return new BooleanReader();
    }

    DictionaryIdReader dictionaryIdReader() {
        return new DictionaryIdReader();
    }

    class LongReader
    extends NumericBaseReader {
        LongReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setLong((long)idx, valuesReader.readLong());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.longDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(reader.readInteger()));
            }
        }

        @Override
        public void nextVals(FieldVector vector, int rowId, VectorizedValuesReader valuesReader, int total) {
            valuesReader.readLongs(total, vector, rowId);
        }
    }

    class DoubleReader
    extends NumericBaseReader {
        DoubleReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setDouble((long)idx, valuesReader.readDouble());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.doubleDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setDouble((long)idx * (long)typeWidth, dict.decodeToDouble(reader.readInteger()));
            }
        }

        @Override
        public void nextVals(FieldVector vector, int rowId, VectorizedValuesReader valuesReader, int total) {
            valuesReader.readDoubles(total, vector, rowId);
        }
    }

    class FloatReader
    extends NumericBaseReader {
        FloatReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setFloat((long)idx, valuesReader.readFloat());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.floatDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setFloat((long)idx * (long)typeWidth, dict.decodeToFloat(reader.readInteger()));
            }
        }

        @Override
        public void nextVals(FieldVector vector, int rowId, VectorizedValuesReader valuesReader, int total) {
            valuesReader.readFloats(total, vector, rowId);
        }
    }

    class IntegerReader
    extends NumericBaseReader {
        IntegerReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, BaseVectorizedParquetValuesReader.Mode mode) {
            vector.getDataBuffer().setInt((long)idx, valuesReader.readInteger());
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.integerDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setInt((long)idx * (long)typeWidth, dict.decodeToInt(reader.readInteger()));
            }
        }

        @Override
        public void nextVals(FieldVector vector, int rowId, VectorizedValuesReader valuesReader, int total) {
            valuesReader.readIntegers(total, vector, rowId);
        }
    }

    class TimestampMillisReader
    extends BaseReader {
        TimestampMillisReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, valuesReader.readLong() * 1000L);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.timestampMillisDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setLong((long)idx * (long)typeWidth, dict.decodeToLong(reader.readInteger()) * 1000L);
            }
        }
    }

    class TimestampInt96Reader
    extends BaseReader {
        TimestampInt96Reader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            ByteBuffer buffer = valuesReader.readBinary(12).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long timestampInt96 = ParquetUtil.extractTimestampInt96((ByteBuffer)buffer);
            vector.getDataBuffer().setLong((long)idx * (long)typeWidth, timestampInt96);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            switch (mode) {
                case RLE: {
                    reader.timestampInt96DictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
                    break;
                }
                case PACKED: {
                    ByteBuffer buffer = dict.decodeToBinary(reader.readInteger()).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                    long timestampInt96 = ParquetUtil.extractTimestampInt96((ByteBuffer)buffer);
                    vector.getDataBuffer().setLong((long)idx, timestampInt96);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported mode for timestamp int96 reader: " + String.valueOf((Object)mode));
                }
            }
        }
    }

    class FixedSizeBinaryReader
    extends BaseReader {
        FixedSizeBinaryReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            valuesReader.readBinary(typeWidth).toByteBuffer().get(byteArray, 0, typeWidth);
            ((FixedSizeBinaryVector)vector).set(idx, byteArray);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.fixedSizeBinaryDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                byte[] bytes = dict.decodeToBinary(reader.readInteger()).getBytes();
                byte[] vectorBytes = new byte[typeWidth];
                System.arraycopy(bytes, 0, vectorBytes, 0, typeWidth);
                ((FixedSizeBinaryVector)vector).set(idx, vectorBytes);
            }
        }
    }

    class VarWidthReader
    extends BaseReader {
        VarWidthReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            int len = valuesReader.readInteger();
            ByteBuffer buffer = valuesReader.readBinary(len).toByteBuffer();
            ((BaseVariableWidthVector)vector).setValueLengthSafe(idx, len);
            int startOffset = ((BaseVariableWidthVector)vector).getStartOffset(idx);
            vector.getDataBuffer().setBytes((long)startOffset, buffer);
            if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)idx);
            }
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.varWidthBinaryDictEncodedReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                ((BaseVariableWidthVector)vector).setSafe(idx, dict.decodeToBinary(reader.readInteger()).getBytesUnsafe());
            }
        }
    }

    class BooleanReader
    extends BaseReader {
        BooleanReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            ((BitVector)vector).setSafe(idx, valuesReader.readBoolean() ? 1 : 0);
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            throw new UnsupportedOperationException();
        }
    }

    class DictionaryIdReader
    extends BaseReader {
        DictionaryIdReader() {
        }

        @Override
        protected void nextVal(FieldVector vector, int idx, VectorizedValuesReader valuesReader, int typeWidth, byte[] byteArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void nextDictEncodedVal(FieldVector vector, int idx, VectorizedDictionaryEncodedParquetValuesReader reader, Dictionary dict, BaseVectorizedParquetValuesReader.Mode mode, int numValues, NullabilityHolder holder, int typeWidth) {
            if (BaseVectorizedParquetValuesReader.Mode.RLE.equals((Object)mode)) {
                reader.dictionaryIdReader().nextBatch(vector, idx, numValues, dict, holder, typeWidth);
            } else if (BaseVectorizedParquetValuesReader.Mode.PACKED.equals((Object)mode)) {
                vector.getDataBuffer().setInt((long)idx * 4L, reader.readInteger());
            }
        }
    }

    abstract class BaseReader
    extends CommonReader {
        BaseReader() {
        }

        @Override
        protected void nextRleBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader, int idx, int numValues, byte[] byteArray) {
            int bufferIdx = idx;
            if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                for (int i = 0; i < numValues; ++i) {
                    this.nextVal(vector, bufferIdx, valuesReader, typeWidth, byteArray);
                    nullabilityHolder.setNotNull(bufferIdx);
                    ++bufferIdx;
                }
            } else {
                VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, bufferIdx, numValues, vector.getValidityBuffer());
            }
        }

        @Override
        protected void nextPackedBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader, int idx, int numValues, byte[] byteArray) {
            int bufferIdx = idx;
            for (int i = 0; i < numValues; ++i) {
                if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                    this.nextVal(vector, bufferIdx, valuesReader, typeWidth, byteArray);
                    nullabilityHolder.setNotNull(bufferIdx);
                } else {
                    VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, bufferIdx, vector.getValidityBuffer());
                }
                ++bufferIdx;
            }
        }

        protected abstract void nextVal(FieldVector var1, int var2, VectorizedValuesReader var3, int var4, byte[] var5);
    }

    abstract class NumericBaseReader
    extends CommonReader {
        NumericBaseReader() {
        }

        @Override
        protected void nextRleBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader, int idx, int numValues, byte[] byteArray) {
            this.setNextNValuesInVector(nullabilityHolder, valuesReader, idx, vector, numValues);
        }

        @Override
        protected void nextPackedBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader, int idx, int numValues, byte[] byteArray) {
            int bufferIdx = idx;
            for (int i = 0; i < numValues; ++i) {
                if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                    this.nextVal(vector, bufferIdx * typeWidth, valuesReader, VectorizedParquetDefinitionLevelReader.this.mode);
                    nullabilityHolder.setNotNull(bufferIdx);
                    if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                        BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)bufferIdx);
                    }
                } else {
                    VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, bufferIdx, vector.getValidityBuffer());
                }
                ++bufferIdx;
            }
        }

        protected abstract void nextVal(FieldVector var1, int var2, VectorizedValuesReader var3, BaseVectorizedParquetValuesReader.Mode var4);

        public abstract void nextVals(FieldVector var1, int var2, VectorizedValuesReader var3, int var4);

        private void setNextNValuesInVector(NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader, int bufferIdx, FieldVector vector, int numValues) {
            ArrowBuf validityBuffer = vector.getValidityBuffer();
            if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                this.nextVals(vector, bufferIdx, valuesReader, numValues);
                nullabilityHolder.setNotNulls(bufferIdx, numValues);
                if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                    for (int i = 0; i < numValues; ++i) {
                        BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)(bufferIdx + i));
                    }
                }
            } else {
                VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, bufferIdx, numValues, validityBuffer);
            }
        }
    }

    abstract class CommonReader {
        CommonReader() {
        }

        private void nextBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, ReaderFunction consumer) {
            int idx = startOffset;
            int left = numValsToRead;
            while (left > 0) {
                if (VectorizedParquetDefinitionLevelReader.this.currentCount == 0) {
                    VectorizedParquetDefinitionLevelReader.this.readNextGroup();
                }
                int numValues = Math.min(left, VectorizedParquetDefinitionLevelReader.this.currentCount);
                byte[] byteArray = null;
                if (typeWidth > -1) {
                    byteArray = new byte[typeWidth];
                }
                ArrowBuf validityBuffer = vector.getValidityBuffer();
                consumer.apply(VectorizedParquetDefinitionLevelReader.this.mode, idx, numValues, byteArray, validityBuffer);
                idx += numValues;
                left -= numValues;
                VectorizedParquetDefinitionLevelReader.this.currentCount -= numValues;
            }
        }

        public void nextBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, VectorizedValuesReader valuesReader) {
            this.nextBatch(vector, startOffset, typeWidth, numValsToRead, (mode, idx, numValues, byteArray, validityBuffer) -> {
                switch (mode) {
                    case RLE: {
                        this.nextRleBatch(vector, typeWidth, nullabilityHolder, valuesReader, idx, numValues, byteArray);
                        break;
                    }
                    case PACKED: {
                        this.nextPackedBatch(vector, typeWidth, nullabilityHolder, valuesReader, idx, numValues, byteArray);
                    }
                }
            });
        }

        public void nextDictEncodedBatch(FieldVector vector, int startOffset, int typeWidth, int numValsToRead, NullabilityHolder nullabilityHolder, VectorizedDictionaryEncodedParquetValuesReader valuesReader, Dictionary dict) {
            this.nextBatch(vector, startOffset, typeWidth, numValsToRead, (mode, idx, numValues, byteArray, validityBuffer) -> {
                switch (mode) {
                    case RLE: {
                        this.nextRleDictEncodedBatch(vector, typeWidth, nullabilityHolder, valuesReader, dict, idx, numValues, validityBuffer);
                        break;
                    }
                    case PACKED: {
                        this.nextPackedDictEncodedBatch(vector, typeWidth, nullabilityHolder, valuesReader, dict, idx, numValues, validityBuffer);
                    }
                }
            });
        }

        protected abstract void nextRleBatch(FieldVector var1, int var2, NullabilityHolder var3, VectorizedValuesReader var4, int var5, int var6, byte[] var7);

        protected abstract void nextPackedBatch(FieldVector var1, int var2, NullabilityHolder var3, VectorizedValuesReader var4, int var5, int var6, byte[] var7);

        protected void nextRleDictEncodedBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedDictionaryEncodedParquetValuesReader valuesReader, Dictionary dict, int idx, int numValues, ArrowBuf validityBuffer) {
            if (VectorizedParquetDefinitionLevelReader.this.currentValue == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                this.nextDictEncodedVal(vector, idx, valuesReader, dict, VectorizedParquetDefinitionLevelReader.this.mode, numValues, nullabilityHolder, typeWidth);
            } else {
                VectorizedParquetDefinitionLevelReader.this.setNulls(nullabilityHolder, idx, numValues, validityBuffer);
            }
        }

        protected void nextPackedDictEncodedBatch(FieldVector vector, int typeWidth, NullabilityHolder nullabilityHolder, VectorizedDictionaryEncodedParquetValuesReader valuesReader, Dictionary dict, int idx, int numValues, ArrowBuf validityBuffer) {
            int bufferIdx = idx;
            for (int i = 0; i < numValues; ++i) {
                if (VectorizedParquetDefinitionLevelReader.this.packedValuesBuffer[VectorizedParquetDefinitionLevelReader.this.packedValuesBufferIdx++] == VectorizedParquetDefinitionLevelReader.this.maxDefLevel) {
                    this.nextDictEncodedVal(vector, bufferIdx, valuesReader, dict, VectorizedParquetDefinitionLevelReader.this.mode, numValues, nullabilityHolder, typeWidth);
                    nullabilityHolder.setNotNull(bufferIdx);
                    if (VectorizedParquetDefinitionLevelReader.this.setArrowValidityVector) {
                        BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)bufferIdx);
                    }
                } else {
                    VectorizedParquetDefinitionLevelReader.this.setNull(nullabilityHolder, bufferIdx, validityBuffer);
                }
                ++bufferIdx;
            }
        }

        protected abstract void nextDictEncodedVal(FieldVector var1, int var2, VectorizedDictionaryEncodedParquetValuesReader var3, Dictionary var4, BaseVectorizedParquetValuesReader.Mode var5, int var6, NullabilityHolder var7, int var8);
    }

    @FunctionalInterface
    static interface ReaderFunction {
        public void apply(BaseVectorizedParquetValuesReader.Mode var1, int var2, int var3, byte[] var4, ArrowBuf var5);
    }
}

