/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.arrow.vector.FieldVector;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedValuesReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class VectorizedDeltaEncodedValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private int blockSizeInValues;
    private int miniBlocksPerBlock;
    private int totalValueCount;
    private long firstValue;
    private int miniBlockSizeInValues;
    private int valuesRead = 0;
    private long lastValueRead;
    private long minDeltaInCurrentBlock;
    private int currentMiniBlock = 0;
    private int[] bitWidths;
    private int remainingInBlock = 0;
    private int remainingInMiniBlock = 0;
    private long[] unpackedValuesBuffer;
    private ByteBufferInputStream inputStream;
    private int intVal;
    private long longVal;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        Preconditions.checkArgument((valueCount >= 1 ? 1 : 0) != 0, (Object)("Page must have at least one value, but it has " + valueCount));
        this.inputStream = in;
        this.blockSizeInValues = BytesUtils.readUnsignedVarInt((InputStream)this.inputStream);
        this.miniBlocksPerBlock = BytesUtils.readUnsignedVarInt((InputStream)this.inputStream);
        double miniSize = (double)this.blockSizeInValues / (double)this.miniBlocksPerBlock;
        Preconditions.checkArgument((miniSize % 8.0 == 0.0 ? 1 : 0) != 0, (Object)("miniBlockSize must be multiple of 8, but it's " + miniSize));
        this.miniBlockSizeInValues = (int)miniSize;
        this.totalValueCount = BytesUtils.readUnsignedVarInt((InputStream)this.inputStream);
        this.bitWidths = new int[this.miniBlocksPerBlock];
        this.unpackedValuesBuffer = new long[this.miniBlockSizeInValues];
        this.firstValue = BytesUtils.readZigZagVarLong((InputStream)this.inputStream);
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException("readByte is not supported");
    }

    @Override
    public short readShort() {
        throw new UnsupportedOperationException("readShort is not supported");
    }

    @Override
    public int readInteger() {
        this.readValues(1, null, 0, 4, (f, i, v) -> {
            this.intVal = (int)v;
        });
        return this.intVal;
    }

    @Override
    public long readLong() {
        this.readValues(1, null, 0, 8, (f, i, v) -> {
            this.longVal = v;
        });
        return this.longVal;
    }

    public void skip() {
        throw new UnsupportedOperationException("skip is not supported");
    }

    @Override
    public Binary readBinary(int len) {
        throw new UnsupportedOperationException("readBinary is not supported");
    }

    @Override
    public void readIntegers(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 4, (f, i, v) -> f.getDataBuffer().setInt(i, (int)v));
    }

    @Override
    public void readLongs(int total, FieldVector vec, int rowId) {
        this.readValues(total, vec, rowId, 8, (f, i, v) -> f.getDataBuffer().setLong(i, v));
    }

    @Override
    public void readFloats(int total, FieldVector vec, int rowId) {
        throw new UnsupportedOperationException("readFloats is not supported");
    }

    @Override
    public void readDoubles(int total, FieldVector vec, int rowId) {
        throw new UnsupportedOperationException("readDoubles is not supported");
    }

    private void readValues(int total, FieldVector vec, int rowId, int typeWidth, IntegerOutputWriter outputWriter) {
        if (this.valuesRead + total > this.totalValueCount) {
            throw new ParquetDecodingException("No more values to read. Total values read:  " + this.valuesRead + ", total count: " + this.totalValueCount + ", trying to read " + total + " more.");
        }
        int remaining = total;
        int currentRowId = rowId;
        if (this.valuesRead == 0) {
            outputWriter.write(vec, (long)(currentRowId + this.valuesRead) * (long)typeWidth, this.firstValue);
            this.lastValueRead = this.firstValue;
            ++currentRowId;
            --remaining;
        }
        while (remaining > 0) {
            int loadedRows;
            try {
                loadedRows = this.loadMiniBlockToOutput(remaining, vec, currentRowId, typeWidth, outputWriter);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Error reading mini block.", (Throwable)e);
            }
            currentRowId += loadedRows;
            remaining -= loadedRows;
        }
        this.valuesRead = total - remaining;
    }

    private int loadMiniBlockToOutput(int remaining, FieldVector vec, int rowId, int typeWidth, IntegerOutputWriter outputWriter) throws IOException {
        if (this.remainingInBlock == 0) {
            this.readBlockHeader();
        }
        if (this.remainingInMiniBlock == 0) {
            this.unpackMiniBlock();
        }
        int valuesReadInMiniBlock = 0;
        for (int i = this.miniBlockSizeInValues - this.remainingInMiniBlock; i < this.miniBlockSizeInValues && valuesReadInMiniBlock < remaining; ++valuesReadInMiniBlock, ++i) {
            long outValue;
            this.lastValueRead = outValue = this.lastValueRead + this.minDeltaInCurrentBlock + this.unpackedValuesBuffer[i];
            outputWriter.write(vec, (long)(rowId + valuesReadInMiniBlock) * (long)typeWidth, outValue);
            --this.remainingInBlock;
            --this.remainingInMiniBlock;
        }
        return valuesReadInMiniBlock;
    }

    private void readBlockHeader() {
        try {
            this.minDeltaInCurrentBlock = BytesUtils.readZigZagVarLong((InputStream)this.inputStream);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Can not read min delta in current block", (Throwable)e);
        }
        this.readBitWidthsForMiniBlocks();
        this.remainingInBlock = this.blockSizeInValues;
        this.currentMiniBlock = 0;
        this.remainingInMiniBlock = 0;
    }

    private void unpackMiniBlock() throws IOException {
        Arrays.fill(this.unpackedValuesBuffer, 0L);
        BytePackerForLong packer = Packer.LITTLE_ENDIAN.newBytePackerForLong(this.bitWidths[this.currentMiniBlock]);
        for (int j = 0; j < this.miniBlockSizeInValues; j += 8) {
            ByteBuffer buffer = this.inputStream.slice(packer.getBitWidth());
            if (buffer.hasArray()) {
                packer.unpack8Values(buffer.array(), buffer.arrayOffset() + buffer.position(), this.unpackedValuesBuffer, j);
                continue;
            }
            packer.unpack8Values(buffer, buffer.position(), this.unpackedValuesBuffer, j);
        }
        this.remainingInMiniBlock = this.miniBlockSizeInValues;
        ++this.currentMiniBlock;
    }

    private void readBitWidthsForMiniBlocks() {
        for (int i = 0; i < this.miniBlocksPerBlock; ++i) {
            try {
                this.bitWidths[i] = BytesUtils.readIntLittleEndianOnOneByte((InputStream)this.inputStream);
                continue;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Can not decode bitwidth in block header", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    static interface IntegerOutputWriter {
        public void write(FieldVector var1, long var2, long var4);
    }
}

