/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.util.Arrays;
import java.util.Locale;
import org.apache.arrow.vector.DecimalVector;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;

public class DecimalVectorUtil {
    private DecimalVectorUtil() {
    }

    public static void setBigEndian(DecimalVector vector, int idx, byte[] value) {
        byte[] paddedBytes = DecimalVectorUtil.padBigEndianBytes(value, 16);
        vector.setBigEndian(idx, paddedBytes);
    }

    @VisibleForTesting
    static byte[] padBigEndianBytes(byte[] bigEndianBytes, int newLength) {
        if (bigEndianBytes.length == newLength) {
            return bigEndianBytes;
        }
        if (bigEndianBytes.length < newLength) {
            byte[] result = new byte[newLength];
            if (bigEndianBytes.length == 0) {
                return result;
            }
            int start = newLength - bigEndianBytes.length;
            if (bigEndianBytes[0] < 0) {
                Arrays.fill(result, 0, start, (byte)-1);
            }
            System.arraycopy(bigEndianBytes, 0, result, start, bigEndianBytes.length);
            return result;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Buffer size of %d is larger than requested size of %d", bigEndianBytes.length, newLength));
    }
}

