/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.iceberg.Schema;
import org.apache.iceberg.arrow.ArrowAllocation;
import org.apache.iceberg.arrow.vectorized.VectorizedArrowReader;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class VectorizedReaderBuilder
extends TypeWithSchemaVisitor<VectorizedReader<?>> {
    private final MessageType parquetSchema;
    private final Schema icebergSchema;
    private final BufferAllocator rootAllocator;
    private final Map<Integer, ?> idToConstant;
    private final boolean setArrowValidityVector;
    private final Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory;
    private final BiFunction<Type, Object, Object> convert;

    public VectorizedReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory) {
        this(expectedSchema, parquetSchema, setArrowValidityVector, idToConstant, readerFactory, (type, value) -> value);
    }

    protected VectorizedReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory, BiFunction<Type, Object, Object> convert) {
        this(expectedSchema, parquetSchema, setArrowValidityVector, idToConstant, readerFactory, convert, (BufferAllocator)ArrowAllocation.rootAllocator());
    }

    protected VectorizedReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory, BiFunction<Type, Object, Object> convert, BufferAllocator bufferAllocator) {
        this.parquetSchema = parquetSchema;
        this.icebergSchema = expectedSchema;
        this.rootAllocator = bufferAllocator.newChildAllocator("VectorizedReadBuilder", 0L, Long.MAX_VALUE);
        this.setArrowValidityVector = setArrowValidityVector;
        this.idToConstant = idToConstant;
        this.readerFactory = readerFactory;
        this.convert = convert;
    }

    public VectorizedReader<?> message(Types.StructType expected, MessageType message, List<VectorizedReader<?>> fieldReaders) {
        GroupType groupType = message.asGroupType();
        HashMap readersById = Maps.newHashMap();
        List fields = groupType.getFields();
        IntStream.range(0, fields.size()).filter(pos -> ((org.apache.parquet.schema.Type)fields.get(pos)).getId() != null).forEach(pos -> readersById.put(((org.apache.parquet.schema.Type)fields.get(pos)).getId().intValue(), (VectorizedReader)fieldReaders.get(pos)));
        List icebergFields = expected != null ? expected.fields() : ImmutableList.of();
        ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)icebergFields.size());
        Iterator iterator = icebergFields.iterator();
        while (iterator.hasNext()) {
            Types.NestedField field = (Types.NestedField)iterator.next();
            VectorizedReader<?> reader = VectorizedArrowReader.replaceWithMetadataReader(field, (VectorizedReader)readersById.get(field.fieldId()), this.idToConstant, this.setArrowValidityVector);
            reorderedFields.add(this.defaultReader(field, reader));
        }
        return this.vectorizedReader(reorderedFields);
    }

    private VectorizedReader<?> defaultReader(Types.NestedField field, VectorizedReader<?> reader) {
        if (reader != null) {
            return reader;
        }
        if (field.initialDefault() != null) {
            return this.constantReader(field, this.convert.apply(field.type(), field.initialDefault()));
        }
        if (field.isOptional()) {
            return VectorizedArrowReader.nulls();
        }
        throw new IllegalArgumentException(String.format("Missing required field: %s", field.name()));
    }

    private <T> VectorizedArrowReader.ConstantVectorReader<T> constantReader(Types.NestedField field, T constant) {
        return new VectorizedArrowReader.ConstantVectorReader<T>(field, constant);
    }

    protected VectorizedReader<?> vectorizedReader(List<VectorizedReader<?>> reorderedFields) {
        return this.readerFactory.apply(reorderedFields);
    }

    public VectorizedReader<?> struct(Types.StructType expected, GroupType groupType, List<VectorizedReader<?>> fieldReaders) {
        if (expected != null) {
            throw new UnsupportedOperationException("Vectorized reads are not supported yet for struct fields");
        }
        return null;
    }

    public VectorizedReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
        if (primitive.getId() == null) {
            return null;
        }
        int parquetFieldId = primitive.getId().intValue();
        ColumnDescriptor desc = this.parquetSchema.getColumnDescription(this.currentPath());
        if (desc.getMaxRepetitionLevel() > 0) {
            return null;
        }
        Types.NestedField icebergField = this.icebergSchema.findField(parquetFieldId);
        if (icebergField == null) {
            return null;
        }
        return new VectorizedArrowReader(desc, icebergField, this.rootAllocator, this.setArrowValidityVector);
    }
}

