/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.Map;
import java.util.Optional;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.arrow.ArrowAllocation;
import org.apache.iceberg.arrow.ArrowSchemaUtil;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessors;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.arrow.vectorized.parquet.VectorizedColumnIterator;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public class VectorizedArrowReader
implements VectorizedReader<VectorHolder> {
    public static final int DEFAULT_BATCH_SIZE = 5000;
    private static final Integer UNKNOWN_WIDTH = null;
    private static final int AVERAGE_VARIABLE_WIDTH_RECORD_SIZE = 10;
    private final ColumnDescriptor columnDescriptor;
    private final VectorizedColumnIterator vectorizedColumnIterator;
    private final Types.NestedField icebergField;
    private final BufferAllocator rootAlloc;
    private int batchSize;
    private FieldVector vec;
    private Integer typeWidth;
    private ReadType readType;
    private NullabilityHolder nullabilityHolder;
    private Dictionary dictionary;

    public VectorizedArrowReader(ColumnDescriptor desc, Types.NestedField icebergField, BufferAllocator ra, boolean setArrowValidityVector) {
        this.icebergField = icebergField;
        this.columnDescriptor = desc;
        this.rootAlloc = ra;
        this.vectorizedColumnIterator = new VectorizedColumnIterator(desc, "", setArrowValidityVector);
    }

    private VectorizedArrowReader() {
        this(null);
    }

    private VectorizedArrowReader(Types.NestedField icebergField) {
        this.icebergField = icebergField;
        this.batchSize = 5000;
        this.columnDescriptor = null;
        this.rootAlloc = null;
        this.vectorizedColumnIterator = null;
    }

    protected Types.NestedField icebergField() {
        return this.icebergField;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize == 0 ? 5000 : batchSize;
        this.vectorizedColumnIterator.setBatchSize(batchSize);
    }

    public VectorHolder read(VectorHolder reuse, int numValsToRead) {
        boolean dictEncoded = this.vectorizedColumnIterator.producesDictionaryEncodedVector();
        if (reuse == null || !dictEncoded && this.readType == ReadType.DICTIONARY || dictEncoded && this.readType != ReadType.DICTIONARY) {
            if (this.vec != null) {
                this.vec.close();
                this.vec = null;
            }
            this.allocateFieldVector(dictEncoded);
            this.nullabilityHolder = new NullabilityHolder(this.batchSize);
        } else {
            this.vec.setValueCount(0);
            this.nullabilityHolder.reset();
        }
        if (this.vectorizedColumnIterator.hasNext()) {
            if (dictEncoded) {
                this.vectorizedColumnIterator.dictionaryBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
            } else {
                switch (this.readType) {
                    case VARBINARY: 
                    case VARCHAR: {
                        this.vectorizedColumnIterator.varWidthTypeBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
                        break;
                    }
                    case BOOLEAN: {
                        this.vectorizedColumnIterator.booleanBatchReader().nextBatch(this.vec, -1, this.nullabilityHolder);
                        break;
                    }
                    case INT: 
                    case INT_BACKED_DECIMAL: {
                        this.vectorizedColumnIterator.integerBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case LONG: 
                    case LONG_BACKED_DECIMAL: {
                        this.vectorizedColumnIterator.longBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case FLOAT: {
                        this.vectorizedColumnIterator.floatBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case DOUBLE: {
                        this.vectorizedColumnIterator.doubleBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case TIMESTAMP_MILLIS: {
                        this.vectorizedColumnIterator.timestampMillisBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case TIMESTAMP_INT96: {
                        this.vectorizedColumnIterator.timestampInt96BatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                        break;
                    }
                    case UUID: 
                    case FIXED_WIDTH_BINARY: 
                    case FIXED_LENGTH_DECIMAL: {
                        this.vectorizedColumnIterator.fixedSizeBinaryBatchReader().nextBatch(this.vec, this.typeWidth, this.nullabilityHolder);
                    }
                }
            }
        }
        Preconditions.checkState((this.vec.getValueCount() == numValsToRead ? 1 : 0) != 0, (String)"Number of values read, %s, does not equal expected, %s", (int)this.vec.getValueCount(), (int)numValsToRead);
        return new VectorHolder(this.columnDescriptor, this.vec, dictEncoded, this.dictionary, this.nullabilityHolder, this.icebergField);
    }

    private void allocateFieldVector(boolean dictionaryEncodedVector) {
        Preconditions.checkState((this.vec == null ? 1 : 0) != 0, (Object)"Allocation must be called only when the previous vector instance was released");
        if (dictionaryEncodedVector) {
            this.allocateDictEncodedVector();
        } else {
            Field arrowField = ArrowSchemaUtil.convert(VectorizedArrowReader.getPhysicalType(this.columnDescriptor, this.icebergField));
            if (this.columnDescriptor.getPrimitiveType().getLogicalTypeAnnotation() != null) {
                this.allocateVectorBasedOnLogicalType(this.columnDescriptor.getPrimitiveType(), arrowField);
            } else {
                this.allocateVectorBasedOnTypeName(this.columnDescriptor.getPrimitiveType(), arrowField);
            }
        }
    }

    private static Types.NestedField getPhysicalType(ColumnDescriptor desc, Types.NestedField logicalType) {
        PrimitiveType primitive = desc.getPrimitiveType();
        PrimitiveType.PrimitiveTypeName typeName = primitive.getPrimitiveTypeName();
        Types.NestedField physicalType = logicalType;
        if (primitive.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            Object type = PrimitiveType.PrimitiveTypeName.INT64.equals((Object)typeName) ? Types.LongType.get() : (PrimitiveType.PrimitiveTypeName.INT32.equals((Object)typeName) ? Types.IntegerType.get() : Types.FixedType.ofLength((int)primitive.getTypeLength()));
            physicalType = Types.NestedField.from((Types.NestedField)logicalType).ofType((Type)type).build();
        }
        return physicalType;
    }

    private void allocateDictEncodedVector() {
        Field field = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.Int(32, true), null, null), null);
        this.vec = field.createVector(this.rootAlloc);
        ((IntVector)this.vec).allocateNew(this.batchSize);
        this.typeWidth = 4;
        this.readType = ReadType.DICTIONARY;
    }

    private void allocateVectorBasedOnLogicalType(PrimitiveType primitive, Field arrowField) {
        LogicalTypeVisitorResult logicalTypeVisitorResult = (LogicalTypeVisitorResult)primitive.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeVisitor(arrowField, primitive)).orElseThrow(() -> new UnsupportedOperationException("Unsupported logical type: " + String.valueOf(primitive.getOriginalType())));
        this.readType = logicalTypeVisitorResult.readType;
        this.typeWidth = logicalTypeVisitorResult.typeWidth;
        this.vec = logicalTypeVisitorResult.vec;
    }

    private void allocateVectorBasedOnTypeName(PrimitiveType primitive, Field arrowField) {
        switch (primitive.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: {
                int len;
                if (this.icebergField.type() instanceof Types.UUIDType) {
                    len = 16;
                    this.readType = ReadType.UUID;
                } else {
                    len = ((Types.FixedType)this.icebergField.type()).length();
                    this.readType = ReadType.FIXED_WIDTH_BINARY;
                }
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * len);
                this.vec.allocateNew();
                this.typeWidth = len;
                break;
            }
            case BINARY: {
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * 10);
                this.vec.allocateNewSafe();
                this.readType = ReadType.VARBINARY;
                this.typeWidth = UNKNOWN_WIDTH;
                break;
            }
            case INT32: {
                Field intField = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.Int(32, true), null, null), null);
                this.vec = intField.createVector(this.rootAlloc);
                ((IntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.INT;
                this.typeWidth = 4;
                break;
            }
            case INT96: {
                int length = 8;
                this.readType = ReadType.TIMESTAMP_INT96;
                this.vec = arrowField.createVector(this.rootAlloc);
                this.vec.setInitialCapacity(this.batchSize * length);
                this.vec.allocateNew();
                this.typeWidth = length;
                break;
            }
            case FLOAT: {
                Field floatField = new Field(this.icebergField.name(), new FieldType(this.icebergField.isOptional(), (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null, null), null);
                this.vec = floatField.createVector(this.rootAlloc);
                ((Float4Vector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.FLOAT;
                this.typeWidth = 4;
                break;
            }
            case BOOLEAN: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BitVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.BOOLEAN;
                this.typeWidth = UNKNOWN_WIDTH;
                break;
            }
            case INT64: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((BigIntVector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.LONG;
                this.typeWidth = 8;
                break;
            }
            case DOUBLE: {
                this.vec = arrowField.createVector(this.rootAlloc);
                ((Float8Vector)this.vec).allocateNew(this.batchSize);
                this.readType = ReadType.DOUBLE;
                this.typeWidth = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(primitive));
            }
        }
    }

    public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
        ColumnChunkMetaData chunkMetaData = metadata.get(ColumnPath.get((String[])this.columnDescriptor.getPath()));
        this.dictionary = this.vectorizedColumnIterator.setRowGroupInfo(source.getPageReader(this.columnDescriptor), !ParquetUtil.hasNonDictionaryPages((ColumnChunkMetaData)chunkMetaData));
    }

    public void close() {
        if (this.vec != null) {
            this.vec.close();
        }
    }

    public String toString() {
        return this.columnDescriptor.toString();
    }

    public static VectorizedArrowReader nulls() {
        return NullVectorReader.INSTANCE;
    }

    public static VectorizedArrowReader positions() {
        return new PositionVectorReader(false);
    }

    public static VectorizedArrowReader positionsWithSetArrowValidityVector() {
        return new PositionVectorReader(true);
    }

    public static VectorizedArrowReader rowIds(Long baseRowId, VectorizedArrowReader idReader) {
        if (baseRowId != null) {
            return new RowIdVectorReader(baseRowId, idReader);
        }
        return VectorizedArrowReader.nulls();
    }

    public static VectorizedArrowReader lastUpdated(Long baseRowId, Long fileLastUpdated, VectorizedArrowReader seqReader) {
        if (fileLastUpdated != null && baseRowId != null) {
            return new LastUpdatedSeqVectorReader(fileLastUpdated, seqReader);
        }
        return VectorizedArrowReader.nulls();
    }

    public static VectorizedReader<?> replaceWithMetadataReader(Types.NestedField icebergField, VectorizedReader<?> reader, Map<Integer, ?> idToConstant, boolean setArrowValidityVector) {
        int id = icebergField.fieldId();
        if (id == MetadataColumns.ROW_ID.fieldId()) {
            Long baseRowId = (Long)idToConstant.get(id);
            return VectorizedArrowReader.rowIds(baseRowId, (VectorizedArrowReader)reader);
        }
        if (id == MetadataColumns.LAST_UPDATED_SEQUENCE_NUMBER.fieldId()) {
            Long baseRowId = (Long)idToConstant.get(MetadataColumns.ROW_ID.fieldId());
            Long fileSeqNumber = (Long)idToConstant.get(id);
            return VectorizedArrowReader.lastUpdated(baseRowId, fileSeqNumber, (VectorizedArrowReader)reader);
        }
        if (idToConstant.containsKey(id)) {
            return new ConstantVectorReader(icebergField, idToConstant.get(id));
        }
        if (id == MetadataColumns.ROW_POSITION.fieldId()) {
            if (setArrowValidityVector) {
                return VectorizedArrowReader.positionsWithSetArrowValidityVector();
            }
            return VectorizedArrowReader.positions();
        }
        if (id == MetadataColumns.IS_DELETED.fieldId()) {
            return new DeletedVectorReader();
        }
        return reader;
    }

    private static boolean isNull(VectorHolder holder, int index) {
        return holder.nullabilityHolder().isNullAt(index) == 1;
    }

    private static BigIntVector allocateBigIntVector(Field field, int valueCount) {
        BigIntVector vector = (BigIntVector)field.createVector((BufferAllocator)ArrowAllocation.rootAllocator());
        vector.allocateNew(valueCount);
        return vector;
    }

    private static NullabilityHolder newNullabilityHolder(int size) {
        NullabilityHolder nullabilityHolder = new NullabilityHolder(size);
        nullabilityHolder.setNotNulls(0, size);
        return nullabilityHolder;
    }

    private static enum ReadType {
        FIXED_LENGTH_DECIMAL,
        INT_BACKED_DECIMAL,
        LONG_BACKED_DECIMAL,
        VARCHAR,
        VARBINARY,
        FIXED_WIDTH_BINARY,
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        TIMESTAMP_MILLIS,
        TIMESTAMP_INT96,
        TIME_MICROS,
        UUID,
        DICTIONARY;

    }

    private final class LogicalTypeVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<LogicalTypeVisitorResult> {
        private final Field arrowField;
        private final PrimitiveType primitive;

        LogicalTypeVisitor(Field arrowField, PrimitiveType primitive) {
            this.arrowField = arrowField;
            this.primitive = primitive;
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return this.allocateVectorForEnumJsonBsonString();
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
            return this.allocateVectorForEnumJsonBsonString();
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            ((FixedSizeBinaryVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
            return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.UUID, this.primitive.getTypeLength()));
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            switch (this.primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    ((FixedSizeBinaryVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.FIXED_LENGTH_DECIMAL, this.primitive.getTypeLength()));
                }
                case INT64: {
                    ((BigIntVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.LONG_BACKED_DECIMAL, 8));
                }
                case INT32: {
                    ((IntVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.INT_BACKED_DECIMAL, 4));
                }
            }
            throw new UnsupportedOperationException("Unsupported base type for decimal: " + String.valueOf(this.primitive.getPrimitiveTypeName()));
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            ((DateDayVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
            return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.INT, 4));
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            ((TimeMicroVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
            return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.LONG, 8));
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            switch (timestampLogicalType.getUnit()) {
                case MILLIS: {
                    ((BigIntVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.TIMESTAMP_MILLIS, 8));
                }
                case MICROS: {
                    if (((Types.TimestampType)VectorizedArrowReader.this.icebergField.type()).shouldAdjustToUTC()) {
                        ((TimeStampMicroTZVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    } else {
                        ((TimeStampMicroVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    }
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.LONG, 8));
                }
                case NANOS: {
                    if (((Types.TimestampNanoType)VectorizedArrowReader.this.icebergField.type()).shouldAdjustToUTC()) {
                        ((TimeStampNanoTZVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    } else {
                        ((TimeStampNanoVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                    }
                    return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.LONG, 8));
                }
            }
            return Optional.empty();
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            int bitWidth = intLogicalType.getBitWidth();
            if (bitWidth == 8 || bitWidth == 16 || bitWidth == 32) {
                ((IntVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.INT, 4));
            }
            if (bitWidth == 64) {
                ((BigIntVector)vector).allocateNew(VectorizedArrowReader.this.batchSize);
                return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.LONG, 8));
            }
            return Optional.empty();
        }

        private Optional<LogicalTypeVisitorResult> allocateVectorForEnumJsonBsonString() {
            FieldVector vector = this.arrowField.createVector(VectorizedArrowReader.this.rootAlloc);
            vector.setInitialCapacity(VectorizedArrowReader.this.batchSize * 10);
            vector.allocateNewSafe();
            return Optional.of(new LogicalTypeVisitorResult(vector, ReadType.VARCHAR, UNKNOWN_WIDTH));
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return this.allocateVectorForEnumJsonBsonString();
        }

        public Optional<LogicalTypeVisitorResult> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
            return this.allocateVectorForEnumJsonBsonString();
        }
    }

    private static final class LogicalTypeVisitorResult {
        private final FieldVector vec;
        private final Integer typeWidth;
        private final ReadType readType;

        LogicalTypeVisitorResult(FieldVector vec, ReadType readType, Integer typeWidth) {
            this.vec = vec;
            this.typeWidth = typeWidth;
            this.readType = readType;
        }
    }

    private static final class NullVectorReader
    extends VectorizedArrowReader {
        private static final NullVectorReader INSTANCE = new NullVectorReader();

        private NullVectorReader() {
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.dummyHolder(numValsToRead);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
        }

        @Override
        public String toString() {
            return "NullReader";
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }

    private static final class PositionVectorReader
    extends VectorizedArrowReader {
        private static final Field ROW_POSITION_ARROW_FIELD = ArrowSchemaUtil.convert(MetadataColumns.ROW_POSITION);
        private final boolean setArrowValidityVector;
        private long rowStart;
        private int batchSize;
        private NullabilityHolder nulls;

        PositionVectorReader(boolean setArrowValidityVector) {
            super(MetadataColumns.ROW_POSITION);
            this.setArrowValidityVector = setArrowValidityVector;
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            FieldVector vec;
            if (reuse == null) {
                vec = PositionVectorReader.newVector(this.batchSize);
            } else {
                vec = reuse.vector();
                vec.setValueCount(0);
            }
            ArrowBuf dataBuffer = vec.getDataBuffer();
            for (int i = 0; i < numValsToRead; ++i) {
                dataBuffer.setLong((long)i * 8L, this.rowStart + (long)i);
            }
            if (this.setArrowValidityVector) {
                ArrowBuf validityBuffer = vec.getValidityBuffer();
                for (int i = 0; i < numValsToRead; ++i) {
                    BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)i);
                }
            }
            this.rowStart += (long)numValsToRead;
            vec.setValueCount(numValsToRead);
            return new VectorHolder.PositionVectorHolder(vec, MetadataColumns.ROW_POSITION, this.nulls);
        }

        private static BigIntVector newVector(int valueCount) {
            BigIntVector vector = (BigIntVector)ROW_POSITION_ARROW_FIELD.createVector((BufferAllocator)ArrowAllocation.rootAllocator());
            vector.allocateNew(valueCount);
            return vector;
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
            this.rowStart = (Long)source.getRowIndexOffset().orElseThrow(() -> new IllegalArgumentException("PageReadStore does not contain row index offset"));
        }

        @Override
        public String toString() {
            return this.getClass().toString();
        }

        @Override
        public void setBatchSize(int batchSize) {
            if (this.nulls == null || this.nulls.size() < batchSize) {
                this.nulls = VectorizedArrowReader.newNullabilityHolder(batchSize);
            }
            this.batchSize = batchSize == 0 ? 5000 : batchSize;
        }

        @Override
        public void close() {
        }
    }

    private static final class RowIdVectorReader
    extends VectorizedArrowReader {
        private static final Field ROW_ID_ARROW_FIELD = ArrowSchemaUtil.convert(MetadataColumns.ROW_ID);
        private final long firstRowId;
        private final VectorizedReader<VectorHolder> idReader;
        private final VectorizedReader<VectorHolder> posReader;
        private NullabilityHolder nulls;

        private RowIdVectorReader(long firstRowId, VectorizedArrowReader idReader) {
            this.firstRowId = firstRowId;
            this.idReader = idReader != null ? idReader : RowIdVectorReader.nulls();
            this.posReader = new PositionVectorReader(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            FieldVector positions = null;
            FieldVector ids = null;
            try {
                positions = ((VectorHolder)this.posReader.read(null, numValsToRead)).vector();
                VectorHolder idsHolder = (VectorHolder)this.idReader.read(null, numValsToRead);
                ids = idsHolder.vector();
                ArrowVectorAccessor<?, String, ?, ?> idsAccessor = ids == null ? null : ArrowVectorAccessors.getVectorAccessor(idsHolder);
                BigIntVector rowIds = VectorizedArrowReader.allocateBigIntVector(ROW_ID_ARROW_FIELD, numValsToRead);
                ArrowBuf dataBuffer = rowIds.getDataBuffer();
                for (int i = 0; i < numValsToRead; ++i) {
                    long bufferOffset = (long)i * 8L;
                    if (idsAccessor == null || VectorizedArrowReader.isNull(idsHolder, i)) {
                        long rowId = this.firstRowId + (Long)positions.getObject(i);
                        dataBuffer.setLong(bufferOffset, rowId);
                        continue;
                    }
                    long materializedRowId = idsAccessor.getLong(i);
                    dataBuffer.setLong(bufferOffset, materializedRowId);
                }
                rowIds.setValueCount(numValsToRead);
                VectorHolder vectorHolder = VectorHolder.vectorHolder((FieldVector)rowIds, MetadataColumns.ROW_ID, this.nulls);
                return vectorHolder;
            }
            finally {
                if (positions != null) {
                    positions.close();
                }
                if (ids != null) {
                    ids.close();
                }
            }
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
            this.idReader.setRowGroupInfo(source, metadata);
            this.posReader.setRowGroupInfo(source, metadata);
        }

        @Override
        public void setBatchSize(int batchSize) {
            if (this.nulls == null || this.nulls.size() < batchSize) {
                this.nulls = VectorizedArrowReader.newNullabilityHolder(batchSize);
            }
            this.idReader.setBatchSize(batchSize);
            this.posReader.setBatchSize(batchSize);
        }

        @Override
        public void close() {
        }
    }

    private static final class LastUpdatedSeqVectorReader
    extends VectorizedArrowReader {
        private static final Field LAST_UPDATED_SEQ = ArrowSchemaUtil.convert(MetadataColumns.LAST_UPDATED_SEQUENCE_NUMBER);
        private final long lastUpdatedSeq;
        private final VectorizedReader<VectorHolder> seqReader;
        private NullabilityHolder nulls;

        private LastUpdatedSeqVectorReader(long lastUpdatedSeq, VectorizedReader<VectorHolder> seqReader) {
            this.lastUpdatedSeq = lastUpdatedSeq;
            this.seqReader = seqReader == null ? LastUpdatedSeqVectorReader.nulls() : seqReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            try (FieldVector seqNumbers = null;){
                VectorHolder seqNumbersHolder = (VectorHolder)this.seqReader.read(null, numValsToRead);
                seqNumbers = seqNumbersHolder.vector();
                ArrowVectorAccessor<?, String, ?, ?> seqAccessor = seqNumbers == null ? null : ArrowVectorAccessors.getVectorAccessor(seqNumbersHolder);
                BigIntVector lastUpdatedSequenceNumbers = VectorizedArrowReader.allocateBigIntVector(LAST_UPDATED_SEQ, numValsToRead);
                ArrowBuf dataBuffer = lastUpdatedSequenceNumbers.getDataBuffer();
                for (int i = 0; i < numValsToRead; ++i) {
                    long bufferOffset = (long)i * 8L;
                    if (seqAccessor == null || VectorizedArrowReader.isNull(seqNumbersHolder, i)) {
                        dataBuffer.setLong(bufferOffset, this.lastUpdatedSeq);
                        continue;
                    }
                    long materializedSeqNumber = seqAccessor.getLong(i);
                    dataBuffer.setLong(bufferOffset, materializedSeqNumber);
                }
                lastUpdatedSequenceNumbers.setValueCount(numValsToRead);
                VectorHolder vectorHolder = VectorHolder.vectorHolder((FieldVector)lastUpdatedSequenceNumbers, MetadataColumns.LAST_UPDATED_SEQUENCE_NUMBER, this.nulls);
                return vectorHolder;
            }
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
            this.seqReader.setRowGroupInfo(source, metadata);
        }

        @Override
        public void setBatchSize(int batchSize) {
            if (this.nulls == null || this.nulls.size() < batchSize) {
                this.nulls = VectorizedArrowReader.newNullabilityHolder(batchSize);
            }
            this.seqReader.setBatchSize(batchSize);
        }

        @Override
        public void close() {
        }
    }

    public static class ConstantVectorReader<T>
    extends VectorizedArrowReader {
        private final T value;

        public ConstantVectorReader(Types.NestedField icebergField, T value) {
            super(icebergField);
            this.value = value;
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.constantHolder(this.icebergField(), numValsToRead, this.value);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
        }

        @Override
        public String toString() {
            return String.format("ConstantReader: %s", this.value);
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }

    public static class DeletedVectorReader
    extends VectorizedArrowReader {
        public DeletedVectorReader() {
            super(MetadataColumns.IS_DELETED);
        }

        @Override
        public VectorHolder read(VectorHolder reuse, int numValsToRead) {
            return VectorHolder.deletedVectorHolder(numValsToRead);
        }

        @Override
        public void setRowGroupInfo(PageReadStore source, Map<ColumnPath, ColumnChunkMetaData> metadata) {
        }

        @Override
        public String toString() {
            return "DeletedVectorReader";
        }

        @Override
        public void setBatchSize(int batchSize) {
        }
    }
}

