/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.util.DecimalUtility;
import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public class GenericArrowVectorAccessorFactory<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable> {
    private final Supplier<DecimalFactory<DecimalT>> decimalFactorySupplier;
    private final Supplier<StringFactory<Utf8StringT>> stringFactorySupplier;
    private final Supplier<StructChildFactory<ChildVectorT>> structChildFactorySupplier;
    private final Supplier<ArrayFactory<ChildVectorT, ArrayT>> arrayFactorySupplier;

    protected GenericArrowVectorAccessorFactory(Supplier<DecimalFactory<DecimalT>> decimalFactorySupplier, Supplier<StringFactory<Utf8StringT>> stringFactorySupplier, Supplier<StructChildFactory<ChildVectorT>> structChildFactorySupplier, Supplier<ArrayFactory<ChildVectorT, ArrayT>> arrayFactorySupplier) {
        this.decimalFactorySupplier = decimalFactorySupplier;
        this.stringFactorySupplier = stringFactorySupplier;
        this.structChildFactorySupplier = structChildFactorySupplier;
        this.arrayFactorySupplier = arrayFactorySupplier;
    }

    public ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> getVectorAccessor(VectorHolder holder) {
        PrimitiveType primitive;
        Dictionary dictionary = holder.dictionary();
        boolean isVectorDictEncoded = holder.isDictionaryEncoded();
        FieldVector vector = holder.vector();
        ColumnDescriptor desc = holder.descriptor();
        PrimitiveType primitiveType = primitive = desc == null ? null : desc.getPrimitiveType();
        if (isVectorDictEncoded) {
            return this.getDictionaryVectorAccessor(dictionary, desc, vector, primitive);
        }
        return this.getPlainVectorAccessor(vector, primitive);
    }

    private ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> getDictionaryVectorAccessor(Dictionary dictionary, ColumnDescriptor desc, FieldVector vector, PrimitiveType primitive) {
        Preconditions.checkState((boolean)(vector instanceof IntVector), (Object)"Dictionary ids should be stored in IntVectors only");
        if (primitive.getOriginalType() != null) {
            switch (desc.getPrimitiveType().getOriginalType()) {
                case ENUM: 
                case JSON: 
                case UTF8: 
                case BSON: {
                    return new DictionaryStringAccessor((IntVector)vector, dictionary, this.stringFactorySupplier.get());
                }
                case INT_64: 
                case TIME_MICROS: 
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return new DictionaryLongAccessor((IntVector)vector, dictionary);
                }
                case DECIMAL: {
                    switch (primitive.getPrimitiveTypeName()) {
                        case BINARY: 
                        case FIXED_LEN_BYTE_ARRAY: {
                            return new DictionaryDecimalBinaryAccessor((IntVector)vector, dictionary, this.decimalFactorySupplier.get());
                        }
                        case INT64: {
                            return new DictionaryDecimalLongAccessor((IntVector)vector, dictionary, this.decimalFactorySupplier.get());
                        }
                        case INT32: {
                            return new DictionaryDecimalIntAccessor((IntVector)vector, dictionary, this.decimalFactorySupplier.get());
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported base type for decimal: " + String.valueOf(primitive.getPrimitiveTypeName()));
                }
            }
            throw new UnsupportedOperationException("Unsupported logical type: " + String.valueOf(primitive.getOriginalType()));
        }
        switch (primitive.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryBinaryAccessor((IntVector)vector, dictionary, this.stringFactorySupplier.get());
            }
            case FLOAT: {
                return new DictionaryFloatAccessor((IntVector)vector, dictionary);
            }
            case INT64: {
                return new DictionaryLongAccessor((IntVector)vector, dictionary);
            }
            case INT96: {
                return new DictionaryTimestampInt96Accessor((IntVector)vector, dictionary);
            }
            case DOUBLE: {
                return new DictionaryDoubleAccessor((IntVector)vector, dictionary);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(primitive));
    }

    private ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> getPlainVectorAccessor(FieldVector vector, PrimitiveType primitive) {
        if (vector instanceof BitVector) {
            return new BooleanAccessor((BitVector)vector);
        }
        if (vector instanceof IntVector) {
            if (GenericArrowVectorAccessorFactory.isDecimal(primitive)) {
                return new IntBackedDecimalAccessor((IntVector)vector, this.decimalFactorySupplier.get());
            }
            return new IntAccessor((IntVector)vector);
        }
        if (vector instanceof BigIntVector) {
            if (GenericArrowVectorAccessorFactory.isDecimal(primitive)) {
                return new LongBackedDecimalAccessor((BigIntVector)vector, this.decimalFactorySupplier.get());
            }
            return new LongAccessor((BigIntVector)vector);
        }
        if (vector instanceof Float4Vector) {
            return new FloatAccessor((Float4Vector)vector);
        }
        if (vector instanceof Float8Vector) {
            return new DoubleAccessor((Float8Vector)vector);
        }
        if (vector instanceof DecimalVector) {
            return new DecimalAccessor((DecimalVector)vector, this.decimalFactorySupplier.get());
        }
        if (vector instanceof VarCharVector) {
            return new StringAccessor((VarCharVector)vector, this.stringFactorySupplier.get());
        }
        if (vector instanceof VarBinaryVector) {
            return new BinaryAccessor((VarBinaryVector)vector);
        }
        if (vector instanceof DateDayVector) {
            return new DateAccessor((DateDayVector)vector);
        }
        if (vector instanceof TimeStampMicroTZVector) {
            return new TimestampAccessor((TimeStampMicroTZVector)vector);
        }
        if (vector instanceof TimeStampMicroVector) {
            return new TimestampAccessor((TimeStampMicroVector)vector);
        }
        if (vector instanceof TimeStampNanoVector) {
            return new TimestampAccessor((TimeStampNanoVector)vector);
        }
        if (vector instanceof TimeStampNanoTZVector) {
            return new TimestampAccessor((TimeStampNanoTZVector)vector);
        }
        if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            return new ArrayAccessor(listVector, this.arrayFactorySupplier.get());
        }
        if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            return new StructAccessor(structVector, this.structChildFactorySupplier.get());
        }
        if (vector instanceof TimeMicroVector) {
            return new TimeMicroAccessor((TimeMicroVector)vector);
        }
        if (vector instanceof FixedSizeBinaryVector) {
            if (GenericArrowVectorAccessorFactory.isDecimal(primitive)) {
                return new FixedSizeBinaryBackedDecimalAccessor((FixedSizeBinaryVector)vector, this.decimalFactorySupplier.get());
            }
            return new FixedSizeBinaryAccessor((FixedSizeBinaryVector)vector, this.stringFactorySupplier.get());
        }
        throw new UnsupportedOperationException("Unsupported vector: " + String.valueOf(vector.getClass()));
    }

    private static boolean isDecimal(PrimitiveType primitive) {
        return primitive != null && primitive.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation;
    }

    private static <T> IntFunction<T[]> genericArray(Class<T> genericClass) {
        return length -> GenericArrowVectorAccessorFactory.genericArray(genericClass, length);
    }

    private static <T> T[] genericArray(Class<T> genericClass, int length) {
        return (Object[])Array.newInstance(genericClass, length);
    }

    private static class DictionaryStringAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final Dictionary dictionary;
        private final StringFactory<Utf8StringT> stringFactory;
        private final IntVector offsetVector;
        private final Utf8StringT[] cache;

        DictionaryStringAccessor(IntVector vector, Dictionary dictionary, StringFactory<Utf8StringT> stringFactory) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
            this.stringFactory = stringFactory;
            this.cache = GenericArrowVectorAccessorFactory.genericArray(stringFactory.getGenericClass(), dictionary.getMaxId() + 1);
        }

        @Override
        public final Utf8StringT getUTF8String(int rowId) {
            int offset = this.offsetVector.get(rowId);
            if (this.cache[offset] == null) {
                this.cache[offset] = this.stringFactory.ofByteBuffer(this.dictionary.decodeToBinary(offset).toByteBuffer());
            }
            return this.cache[offset];
        }
    }

    protected static interface StringFactory<Utf8StringT> {
        public Class<Utf8StringT> getGenericClass();

        public Utf8StringT ofRow(VarCharVector var1, int var2);

        default public Utf8StringT ofRow(FixedSizeBinaryVector vector, int rowId) {
            throw new UnsupportedOperationException(String.format("Creating %s from a FixedSizeBinaryVector is not supported", this.getGenericClass().getSimpleName()));
        }

        default public Utf8StringT ofRow(IntVector offsetVector, Dictionary dictionary, int rowId) {
            throw new UnsupportedOperationException(String.format("Creating %s from a Dictionary is not supported", this.getGenericClass().getSimpleName()));
        }

        public Utf8StringT ofBytes(byte[] var1);

        public Utf8StringT ofByteBuffer(ByteBuffer var1);
    }

    private static class DictionaryLongAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector offsetVector;
        private final Dictionary dictionary;

        DictionaryLongAccessor(IntVector vector, Dictionary dictionary) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
        }

        @Override
        public final long getLong(int rowId) {
            return this.dictionary.decodeToLong(this.offsetVector.get(rowId));
        }
    }

    private static class DictionaryDecimalBinaryAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends DictionaryDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        DictionaryDecimalBinaryAccessor(IntVector vector, Dictionary dictionary, DecimalFactory<DecimalT> decimalFactory) {
            super(vector, dictionary, decimalFactory);
        }

        @Override
        protected DecimalT decode(int dictId, int precision, int scale) {
            ByteBuffer byteBuffer = this.parquetDictionary.decodeToBinary(dictId).toByteBuffer();
            BigDecimal value = DecimalUtility.getBigDecimalFromByteBuffer((ByteBuffer)byteBuffer, (int)scale, (int)byteBuffer.remaining());
            return this.decimalFactory.ofBigDecimal(value, precision, scale);
        }
    }

    protected static interface DecimalFactory<DecimalT> {
        public Class<DecimalT> getGenericClass();

        public DecimalT ofLong(long var1, int var3, int var4);

        public DecimalT ofBigDecimal(BigDecimal var1, int var2, int var3);
    }

    private static class DictionaryDecimalLongAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends DictionaryDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        DictionaryDecimalLongAccessor(IntVector vector, Dictionary dictionary, DecimalFactory<DecimalT> decimalFactory) {
            super(vector, dictionary, decimalFactory);
        }

        @Override
        protected DecimalT decode(int dictId, int precision, int scale) {
            return this.decimalFactory.ofLong(this.parquetDictionary.decodeToLong(dictId), precision, scale);
        }
    }

    private static class DictionaryDecimalIntAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends DictionaryDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        DictionaryDecimalIntAccessor(IntVector vector, Dictionary dictionary, DecimalFactory<DecimalT> decimalFactory) {
            super(vector, dictionary, decimalFactory);
        }

        @Override
        protected DecimalT decode(int dictId, int precision, int scale) {
            return this.decimalFactory.ofLong(this.parquetDictionary.decodeToInt(dictId), precision, scale);
        }
    }

    private static class DictionaryBinaryAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector offsetVector;
        private final Dictionary dictionary;
        private final StringFactory<Utf8StringT> stringFactory;

        DictionaryBinaryAccessor(IntVector vector, Dictionary dictionary, StringFactory<Utf8StringT> stringFactory) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
            this.stringFactory = stringFactory;
        }

        @Override
        public final byte[] getBinary(int rowId) {
            return this.dictionary.decodeToBinary(this.offsetVector.get(rowId)).getBytes();
        }

        @Override
        public Utf8StringT getUTF8String(int rowId) {
            return null == this.stringFactory ? super.getUTF8String(rowId) : this.stringFactory.ofRow(this.offsetVector, this.dictionary, rowId);
        }
    }

    private static class DictionaryFloatAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector offsetVector;
        private final Dictionary dictionary;

        DictionaryFloatAccessor(IntVector vector, Dictionary dictionary) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
        }

        @Override
        public final float getFloat(int rowId) {
            return this.dictionary.decodeToFloat(this.offsetVector.get(rowId));
        }

        @Override
        public final double getDouble(int rowId) {
            return this.getFloat(rowId);
        }
    }

    private static class DictionaryTimestampInt96Accessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector offsetVector;
        private final Dictionary dictionary;

        DictionaryTimestampInt96Accessor(IntVector vector, Dictionary dictionary) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
        }

        @Override
        public final long getLong(int rowId) {
            ByteBuffer byteBuffer = this.dictionary.decodeToBinary(this.offsetVector.get(rowId)).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            return ParquetUtil.extractTimestampInt96((ByteBuffer)byteBuffer);
        }
    }

    private static class DictionaryDoubleAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector offsetVector;
        private final Dictionary dictionary;

        DictionaryDoubleAccessor(IntVector vector, Dictionary dictionary) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.dictionary = dictionary;
        }

        @Override
        public final double getDouble(int rowId) {
            return this.dictionary.decodeToDouble(this.offsetVector.get(rowId));
        }
    }

    private static class BooleanAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final BitVector vector;

        BooleanAccessor(BitVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final boolean getBoolean(int rowId) {
            return this.vector.get(rowId) == 1;
        }
    }

    private static class IntBackedDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector vector;
        private final DecimalFactory<DecimalT> decimalFactory;

        IntBackedDecimalAccessor(IntVector vector, DecimalFactory<DecimalT> decimalFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.decimalFactory = decimalFactory;
        }

        @Override
        public final DecimalT getDecimal(int rowId, int precision, int scale) {
            return this.decimalFactory.ofLong(this.vector.get(rowId), precision, scale);
        }
    }

    private static class IntAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final IntVector vector;

        IntAccessor(IntVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final int getInt(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final long getLong(int rowId) {
            return this.getInt(rowId);
        }
    }

    private static class LongBackedDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final BigIntVector vector;
        private final DecimalFactory<DecimalT> decimalFactory;

        LongBackedDecimalAccessor(BigIntVector vector, DecimalFactory<DecimalT> decimalFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.decimalFactory = decimalFactory;
        }

        @Override
        public final DecimalT getDecimal(int rowId, int precision, int scale) {
            return this.decimalFactory.ofLong(this.vector.get(rowId), precision, scale);
        }
    }

    private static class LongAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final BigIntVector vector;

        LongAccessor(BigIntVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class FloatAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final Float4Vector vector;

        FloatAccessor(Float4Vector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final float getFloat(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public final double getDouble(int rowId) {
            return this.getFloat(rowId);
        }
    }

    private static class DoubleAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final Float8Vector vector;

        DoubleAccessor(Float8Vector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final double getDouble(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class DecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final DecimalVector vector;
        private final DecimalFactory<DecimalT> decimalFactory;

        DecimalAccessor(DecimalVector vector, DecimalFactory<DecimalT> decimalFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.decimalFactory = decimalFactory;
        }

        @Override
        public final DecimalT getDecimal(int rowId, int precision, int scale) {
            return this.decimalFactory.ofBigDecimal(DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)this.vector.getDataBuffer(), (int)rowId, (int)scale, (int)16), precision, scale);
        }
    }

    private static class StringAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final VarCharVector vector;
        private final StringFactory<Utf8StringT> stringFactory;

        StringAccessor(VarCharVector vector, StringFactory<Utf8StringT> stringFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.stringFactory = stringFactory;
        }

        @Override
        public final Utf8StringT getUTF8String(int rowId) {
            return this.stringFactory.ofRow(this.vector, rowId);
        }
    }

    private static class BinaryAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final VarBinaryVector vector;

        BinaryAccessor(VarBinaryVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final byte[] getBinary(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class DateAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final DateDayVector vector;

        DateAccessor(DateDayVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final int getInt(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class TimestampAccessor<DecimalT, Utf8StringT, ArrayT, TimestampVectorT extends TimeStampVector, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final TimestampVectorT vector;

        TimestampAccessor(TimestampVectorT vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class ArrayAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final ListVector vector;
        private final ChildVectorT arrayData;
        private final ArrayFactory<ChildVectorT, ArrayT> arrayFactory;

        ArrayAccessor(ListVector vector, ArrayFactory<ChildVectorT, ArrayT> arrayFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.arrayFactory = arrayFactory;
            this.arrayData = (AutoCloseable)arrayFactory.ofChild((ValueVector)vector.getDataVector());
        }

        @Override
        public final ArrayT getArray(int rowId) {
            return this.arrayFactory.ofRow((ValueVector)this.vector, this.arrayData, rowId);
        }
    }

    protected static interface ArrayFactory<ChildVectorT, ArrayT> {
        public ChildVectorT ofChild(ValueVector var1);

        public ArrayT ofRow(ValueVector var1, ChildVectorT var2, int var3);
    }

    private static class StructAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        StructAccessor(StructVector structVector, StructChildFactory<ChildVectorT> structChildFactory) {
            super((ValueVector)structVector, (AutoCloseable[])IntStream.range(0, structVector.size()).mapToObj(arg_0 -> ((StructVector)structVector).getVectorById(arg_0)).map(structChildFactory::of).toArray(GenericArrowVectorAccessorFactory.genericArray(structChildFactory.getGenericClass())));
        }
    }

    protected static interface StructChildFactory<ChildVectorT> {
        public Class<ChildVectorT> getGenericClass();

        public ChildVectorT of(ValueVector var1);
    }

    private static class TimeMicroAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final TimeMicroVector vector;

        TimeMicroAccessor(TimeMicroVector vector) {
            super((ValueVector)vector);
            this.vector = vector;
        }

        @Override
        public final long getLong(int rowId) {
            return this.vector.get(rowId);
        }
    }

    private static class FixedSizeBinaryBackedDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final FixedSizeBinaryVector vector;
        private final DecimalFactory<DecimalT> decimalFactory;

        FixedSizeBinaryBackedDecimalAccessor(FixedSizeBinaryVector vector, DecimalFactory<DecimalT> decimalFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.decimalFactory = decimalFactory;
        }

        @Override
        public final DecimalT getDecimal(int rowId, int precision, int scale) {
            byte[] bytes = this.vector.get(rowId);
            BigInteger bigInteger = new BigInteger(bytes);
            BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
            return this.decimalFactory.ofBigDecimal(javaDecimal, precision, scale);
        }
    }

    private static class FixedSizeBinaryAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final FixedSizeBinaryVector vector;
        private final StringFactory<Utf8StringT> stringFactory;

        FixedSizeBinaryAccessor(FixedSizeBinaryVector vector, StringFactory<Utf8StringT> stringFactory) {
            super((ValueVector)vector);
            this.vector = vector;
            this.stringFactory = stringFactory;
        }

        @Override
        public byte[] getBinary(int rowId) {
            return this.vector.get(rowId);
        }

        @Override
        public Utf8StringT getUTF8String(int rowId) {
            return null == this.stringFactory ? super.getUTF8String(rowId) : this.stringFactory.ofRow(this.vector, rowId);
        }
    }

    private static abstract class DictionaryDecimalAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
    extends ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT> {
        private final DecimalT[] cache;
        private final IntVector offsetVector;
        protected final DecimalFactory<DecimalT> decimalFactory;
        protected final Dictionary parquetDictionary;

        private DictionaryDecimalAccessor(IntVector vector, Dictionary dictionary, DecimalFactory<DecimalT> decimalFactory) {
            super((ValueVector)vector);
            this.offsetVector = vector;
            this.parquetDictionary = dictionary;
            this.decimalFactory = decimalFactory;
            this.cache = GenericArrowVectorAccessorFactory.genericArray(decimalFactory.getGenericClass(), dictionary.getMaxId() + 1);
        }

        @Override
        public final DecimalT getDecimal(int rowId, int precision, int scale) {
            int offset = this.offsetVector.get(rowId);
            if (this.cache[offset] == null) {
                this.cache[offset] = this.decode(offset, precision, scale);
            }
            return this.cache[offset];
        }

        protected abstract DecimalT decode(int var1, int var2, int var3);
    }
}

