/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.arrow.vectorized.VectorizedArrowReader;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public abstract class BaseBatchReader<T>
implements VectorizedReader<T> {
    protected final VectorizedArrowReader[] readers;
    protected final VectorHolder[] vectorHolders;

    protected BaseBatchReader(List<VectorizedReader<?>> readers) {
        this.readers = (VectorizedArrowReader[])readers.stream().map(VectorizedArrowReader.class::cast).toArray(VectorizedArrowReader[]::new);
        this.vectorHolders = new VectorHolder[readers.size()];
    }

    public void setRowGroupInfo(PageReadStore pageStore, Map<ColumnPath, ColumnChunkMetaData> metaData) {
        for (VectorizedArrowReader reader : this.readers) {
            if (reader == null) continue;
            reader.setRowGroupInfo(pageStore, metaData);
        }
    }

    protected void closeVectors() {
        for (int i = 0; i < this.vectorHolders.length; ++i) {
            if (this.vectorHolders[i] == null) continue;
            if (this.vectorHolders[i].vector() != null) {
                this.vectorHolders[i].vector().close();
            }
            this.vectorHolders[i] = null;
        }
    }

    public void close() {
        for (VectorizedArrowReader reader : this.readers) {
            if (reader == null) continue;
            reader.close();
        }
        this.closeVectors();
    }

    public void setBatchSize(int batchSize) {
        for (VectorizedArrowReader reader : this.readers) {
            if (reader == null) continue;
            reader.setBatchSize(batchSize);
        }
    }
}

