/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class ArrowSchemaUtil {
    private static final String ORIGINAL_TYPE = "originalType";
    private static final String MAP_TYPE = "mapType";

    private ArrowSchemaUtil() {
    }

    public static org.apache.arrow.vector.types.pojo.Schema convert(Schema schema) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Types.NestedField field : schema.columns()) {
            fields.add((Object)((Field)TypeUtil.visit((Type)field.type(), (TypeUtil.SchemaVisitor)new IcebergToArrowTypeConverter(field))));
        }
        return new org.apache.arrow.vector.types.pojo.Schema((Iterable)fields.build());
    }

    public static Field convert(Types.NestedField field) {
        return (Field)TypeUtil.visit((Type)field.type(), (TypeUtil.SchemaVisitor)new IcebergToArrowTypeConverter(field));
    }

    private static class IcebergToArrowTypeConverter
    extends TypeUtil.SchemaVisitor<Field> {
        private final Types.NestedField currentField;

        IcebergToArrowTypeConverter(Types.NestedField field) {
            this.currentField = field;
        }

        public Field schema(Schema schema, Field structResult) {
            return structResult;
        }

        public Field struct(Types.StructType struct, List<Field> fieldResults) {
            return new Field(this.currentField.name(), new FieldType(this.currentField.isOptional(), (ArrowType)ArrowType.Struct.INSTANCE, null), this.convertChildren(struct.fields()));
        }

        public Field field(Types.NestedField field, Field fieldResult) {
            return fieldResult;
        }

        public Field list(Types.ListType list, Field elementResult) {
            return new Field(this.currentField.name(), new FieldType(this.currentField.isOptional(), (ArrowType)ArrowType.List.INSTANCE, null), this.convertChildren(list.fields()));
        }

        public Field map(Types.MapType map, Field keyResult, Field valueResult) {
            ImmutableMap metadata = ImmutableMap.of((Object)ArrowSchemaUtil.ORIGINAL_TYPE, (Object)ArrowSchemaUtil.MAP_TYPE);
            ArrowType.Map arrowType = new ArrowType.Map(false);
            List<Field> entryFields = this.convertChildren(map.fields());
            Field entry = new Field("", new FieldType(this.currentField.isOptional(), (ArrowType)arrowType, null), entryFields);
            ArrayList children = Lists.newArrayList((Object[])new Field[]{entry});
            return new Field(this.currentField.name(), new FieldType(this.currentField.isOptional(), (ArrowType)arrowType, null, (Map)metadata), (List)children);
        }

        private List<Field> convertChildren(Collection<Types.NestedField> children) {
            ArrayList converted = Lists.newArrayListWithCapacity((int)children.size());
            for (Types.NestedField child : children) {
                converted.add((Field)TypeUtil.visit((Type)child.type(), (TypeUtil.SchemaVisitor)new IcebergToArrowTypeConverter(child)));
            }
            return converted;
        }

        public Field primitive(Type.PrimitiveType primitive) {
            ArrowType.Binary arrowType;
            switch (primitive.typeId()) {
                case BINARY: {
                    arrowType = ArrowType.Binary.INSTANCE;
                    break;
                }
                case FIXED: {
                    Types.FixedType fixedType = (Types.FixedType)primitive;
                    arrowType = new ArrowType.FixedSizeBinary(fixedType.length());
                    break;
                }
                case BOOLEAN: {
                    arrowType = ArrowType.Bool.INSTANCE;
                    break;
                }
                case INTEGER: {
                    arrowType = new ArrowType.Int(32, true);
                    break;
                }
                case LONG: {
                    arrowType = new ArrowType.Int(64, true);
                    break;
                }
                case FLOAT: {
                    arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                    break;
                }
                case DOUBLE: {
                    arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                    break;
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)primitive;
                    arrowType = new ArrowType.Decimal(decimalType.precision(), decimalType.scale(), 128);
                    break;
                }
                case STRING: {
                    arrowType = ArrowType.Utf8.INSTANCE;
                    break;
                }
                case TIME: {
                    arrowType = new ArrowType.Time(TimeUnit.MICROSECOND, 64);
                    break;
                }
                case UUID: {
                    arrowType = new ArrowType.FixedSizeBinary(16);
                    break;
                }
                case TIMESTAMP: {
                    arrowType = new ArrowType.Timestamp(TimeUnit.MICROSECOND, ((Types.TimestampType)primitive).shouldAdjustToUTC() ? "UTC" : null);
                    break;
                }
                case TIMESTAMP_NANO: {
                    arrowType = new ArrowType.Timestamp(TimeUnit.NANOSECOND, ((Types.TimestampNanoType)primitive).shouldAdjustToUTC() ? "UTC" : null);
                    break;
                }
                case DATE: {
                    arrowType = new ArrowType.Date(DateUnit.DAY);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported primitive type: " + String.valueOf(primitive));
                }
            }
            return new Field(this.currentField.name(), new FieldType(this.currentField.isOptional(), (ArrowType)arrowType, null), (List)Lists.newArrayList());
        }
    }
}

