/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum RewriteJobOrder {
    BYTES_ASC("bytes-asc"),
    BYTES_DESC("bytes-desc"),
    FILES_ASC("files-asc"),
    FILES_DESC("files-desc"),
    NONE("none");

    private final String orderName;

    private RewriteJobOrder(String orderName) {
        this.orderName = orderName;
    }

    public String orderName() {
        return this.orderName;
    }

    public static RewriteJobOrder fromName(String orderName) {
        Preconditions.checkArgument((orderName != null ? 1 : 0) != 0, (Object)"Rewrite job order name should not be null");
        return RewriteJobOrder.valueOf(orderName.replaceFirst("-", "_").toUpperCase(Locale.ENGLISH));
    }
}

